/*
 * Decompiled with CFR 0.152.
 */
package analyzecodeC.erlang;

import analyzecodeC.erlang.CtoErlangTrans;
import analyzecodeC.erlang.Element;
import analyzecodeC.erlang.ElementOutput;
import analyzecodeC.erlang.Guardtype;
import java.io.Serializable;

public class ElementGuard
extends Element
implements Guardtype,
Serializable {
    private static final long serialVersionUID = 201002060023000001L;
    private Element express;
    private String ifstr;
    private int strretval = -1;

    public void setExpress(Element expressions) {
        this.express = expressions;
    }

    public Element getExpress() {
        return this.express;
    }

    public String getGuardErl() {
        return "case ";
    }

    public String getGuardErlEnd() {
        return "end";
    }

    public String toErlang(ElementOutput output) {
        StringBuffer retval = new StringBuffer();
        if (this.ifstr.equals("if")) {
            if (this.express instanceof Guardtype) {
                retval.append(super.toErlang(output));
                retval.append(",\n ");
                this.express.toErlang(output);
                retval.append(" of\n ");
            } else {
                retval.append(super.toErlang(output) + " of\n");
                retval.append("    true ->\n");
                retval.append("      " + this.express.toErlang(output));
            }
        } else if (this.ifstr.equals("else")) {
            retval.append("    false ->\n");
            retval.append("      " + this.express.toErlang(output));
        } else if (this.ifstr.equals("switch")) {
            retval.append(super.toErlang(output) + " of\n");
            this.inSwitchToErlang(retval, output);
        } else if (this.defaultToErlang(retval, false)) {
            retval.append(" ->\n");
            retval.append("      " + this.express.toErlang(output));
        } else {
            retval.append(super.toErlang(output));
        }
        return retval.toString();
    }

    private void inSwitchToErlang(StringBuffer retval, ElementOutput output) {
        boolean edited = false;
        Element next = this.express;
        while (next != null) {
            ElementGuard gt;
            if (!(next instanceof Guardtype)) {
                new Error();
            }
            if ((gt = (ElementGuard)next).caseToErlang(retval, edited) || gt.defaultToErlang(retval, edited)) {
                retval.append(" ->\n");
                retval.append("        " + gt.strretval);
                edited = true;
            }
            next = gt.express;
        }
    }

    public void setStrretval(int structretval) {
        this.strretval = structretval;
    }

    private boolean caseToErlang(StringBuffer retval, boolean addsemic) {
        if (!ElementGuard.isCase(this.ifstr)) {
            return false;
        }
        if (addsemic) {
            retval.append(";\n");
        }
        retval.append("    ");
        retval.append(super.toErlang());
        return true;
    }

    public static boolean isBreak(String in) {
        if (in == null) {
            return false;
        }
        return in.equals("break");
    }

    public static boolean isDefault(String in) {
        if (in == null) {
            return false;
        }
        return in.equals("default");
    }

    public static boolean isCase(String in) {
        if (in == null) {
            return false;
        }
        return in.equals("case");
    }

    public boolean isBreak() {
        return this.ifstr.equals("break");
    }

    private boolean defaultToErlang(StringBuffer retval, boolean addsemic) {
        if (!ElementGuard.isDefault(this.ifstr)) {
            return false;
        }
        if (addsemic) {
            retval.append(";\n");
        }
        retval.append("    _");
        return true;
    }

    public static ElementGuard creElementElse(CtoErlangTrans a) {
        if (!a.isStructLine() || !a.getString().equals("else")) {
            return null;
        }
        return ElementGuard.newInstance("else", null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ElementGuard creElementIf(CtoErlangTrans a, CtoErlangTrans b, CtoErlangTrans line) {
        ElementGuard retval = null;
        line.setNextUseCET(null);
        if (!a.isStructLine() || !a.getString().equals("if")) {
            return null;
        }
        if (!b.getString().equals("(")) {
            return null;
        }
        CtoErlangTrans para = line.getNext();
        if (para != null && para.getString() != null && para.getString().equals(")")) {
            Element el = line.thinkEle();
            retval = ElementGuard.newInstance("if", el);
            line.setNextUseCET(para.getNext());
            return retval;
        }
        if (para == null || line.getString() != null && line.getString().equals(")")) return null;
        Element eb = Element.newInstanceBase(para);
        if (eb == null) return null;
        CtoErlangTrans next = para.getNextUseCET();
        if (next.getString() != null && next.getString().equals(")")) {
            retval = ElementGuard.newInstance("if", eb);
        }
        line.setNextUseCET(next.getNext());
        return retval;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ElementGuard creElementSwitch(CtoErlangTrans a, CtoErlangTrans b, CtoErlangTrans line) {
        ElementGuard retval = null;
        line.setNextUseCET(null);
        if (!a.isStructLine() || !a.getString().equals("switch")) {
            return null;
        }
        if (!b.getString().equals("(")) {
            return null;
        }
        CtoErlangTrans para = line.getNext();
        if (para != null && para.getString() != null && para.getString().equals(")")) {
            Element el = line.thinkEle();
            retval = ElementGuard.newInstance("switch", el);
            line.setNextUseCET(para.getNext());
            return retval;
        }
        if (para == null || line.getString() != null && line.getString().equals(")")) return null;
        Element eb = Element.newInstanceBase(para);
        if (eb == null) return null;
        CtoErlangTrans next = para.getNextUseCET();
        if (next.getString() != null && next.getString().equals(")")) {
            retval = ElementGuard.newInstance("switch", eb);
        }
        line.setNextUseCET(next.getNext());
        return retval;
    }

    public static ElementGuard creElementCase(CtoErlangTrans a, CtoErlangTrans b) {
        ElementGuard retval = null;
        b.setNextUseCET(null);
        if (!a.isStructLine() || !ElementGuard.isCase(a.getString())) {
            return null;
        }
        CtoErlangTrans para = b.getNext();
        if (para == null && b.getString() != null) {
            Element el = b.thinkEle();
            retval = ElementGuard.newInstance("case", el);
            return retval;
        }
        return null;
    }

    public static ElementGuard creElementDefault(CtoErlangTrans a) {
        ElementGuard retval = null;
        if (!a.isStructLine() || !a.getString().equals("default")) {
            return null;
        }
        CtoErlangTrans para = a.getNext();
        if (para == null) {
            retval = new ElementGuard();
            retval.ifstr = "default";
            return retval;
        }
        return null;
    }

    public static ElementGuard creElementDefault() {
        ElementGuard retval = new ElementGuard();
        retval.ifstr = "default";
        return retval;
    }

    public static ElementGuard creElementBreak(CtoErlangTrans a) {
        ElementGuard retval = null;
        if (!a.isStructLine() || !a.getString().equals("break")) {
            return null;
        }
        CtoErlangTrans para = a.getNext();
        if (para == null) {
            retval = new ElementGuard();
            retval.ifstr = "break";
            return retval;
        }
        return null;
    }

    private static ElementGuard newInstance(String type, Element cond) {
        ElementGuard retval = new ElementGuard();
        if (cond == null) {
            retval.setEleA("");
        } else {
            retval.setEleA(cond);
        }
        retval.ifstr = type;
        return retval;
    }
}

