/*
 * Decompiled with CFR 0.152.
 */
package analyzecodeC.erlang;

import analyzecodeC.decode.MemObject;
import analyzecodeC.decode.MemObjects;
import analyzecodeC.decode.ProcessBlock;
import analyzecodeC.decode.ProcessKakko;
import analyzecodeC.decode.ProcessRoute;
import analyzecodeC.decode.StructtypeData;
import analyzecodeC.erlang.EditBuffer;
import analyzecodeC.erlang.ElementOutput;
import analyzecodeC.erlang.InputMemnames;
import analyzecodeC.erlang.ProcessBlockMarge;
import java.io.Serializable;

public class ErlangCreator
implements Serializable {
    private static final long serialVersionUID = 201002060025000001L;
    private ProcessRoute routes = null;
    private static final String GvaTblList = "gval_tabget()->\n  [";
    private static final String GvalKeyList = "gval_keyval()->\n  [";
    private static final String GvalDefList = "gval_defval()->\n  [";
    public static final String STUB_IMPORT = "-import(ctoerlstub,[gval_insert/3,gval_insert/2,gval_new/1,gval_lookup/2,array_val_set/3]).\n\n";
    public static final String INITVAL = "initval()->\ngval_new(gval_tabget()),\ngval_insert(gval_tabget(),gval_keyval(),gval_defval()).\n\n";
    public static final String GvalSet = "gval_insert([],[],[])->false;\ngval_insert([TBN],[TK],[TV])->\n  ets:insert(TBN,{TK,TV});\n\ngval_insert([TBN|TBNL],[TK|BK],[TV|BV])->\n  ets:insert(TBN,{TK,TV}),\n  gval_insert(TBNL,BK,BV);\n\ngval_insert(Tbn,Key,Val)->\n  ets:insert(Tbn,{Key,Val}).\n\ngval_insert(Tbn,Val)->\n  ets:insert(Tbn,{null,Val}).\n\ngval_new([])->false;\ngval_new([TN])->\n  table_new(TN);\ngval_new([TN|TNL])->\n  table_new(TN),\n  gval_new(TNL).\n\ntable_new(Tbl)->\n  case ets:info(Tbl) of\n    undefined ->\n      ets:new(Tbl,[public,set,named_table]);\n    _        ->\n      false\n  end.\n\n";
    public static final String GvalSet_EXP = "-export([gval_insert/3,gval_insert/2,gval_new/1]).\n";
    public static final String GET_EXTMem = "gval_lookup(Tbn,Key)->\n  case ets:lookup(Tbn,Key) of \n    [{_,Val}] -> Val;\n    []->0\n  end.\n\n";
    public static final String GET_EXTMem_EXP = "-export([gval_lookup/2]).\n";
    public static final String ARRAY_VAL_SET = "array_val_set([H],TBN,CNT)->\n  ets:insert(TBN,{CNT,H});\narray_val_set([H|T],TBN,CNT)->\n  ets:insert(TBN,{CNT,H}),\n  array_val_set(T,TBN,CNT+1).\n";
    public static final String ARRAY_VAL_SET_EXP = "-export([array_val_set/3]).\n";
    private ElementOutput output;

    public ErlangCreator(ProcessRoute pr) {
        this.routes = pr;
    }

    public static String creFuncTopWhenArrayUse(EditBuffer out, String funcname, MemObjects mos) {
        StringBuffer retval = new StringBuffer();
        if (mos.hasArrayMemObjs()) {
            MemObject[] mo = mos.getArrayMemObjs();
            retval.append("gval_new([");
            for (int i = 0; i < mo.length; ++i) {
                retval.append(mo[i].getArraydat().getArrayKey());
                if (i >= mo.length - 1) continue;
                retval.append(",");
            }
            retval.append("])");
            out.append(retval.toString());
            out.setLineEndKN();
            return out.toString();
        }
        return retval.toString();
    }

    public static String getErlArrayName(String funcname, MemObject mo) {
        StringBuffer retval = new StringBuffer();
        retval.append(funcname + "_" + mo.getName());
        return retval.toString();
    }

    public static String getErlArrayIni(String arrayname, String inival) {
        StringBuffer retval = new StringBuffer();
        retval.append("array_val_set(");
        retval.append(inival);
        retval.append("," + arrayname);
        retval.append(",0");
        retval.append(")");
        return retval.toString();
    }

    public static String creErlfileTopModule(ProcessKakko pk) {
        StringBuffer retval = new StringBuffer();
        String modname = pk.getModname();
        retval.append("-module(" + modname + ").\n");
        return retval.toString();
    }

    public static String creErlfileTopExport(ProcessKakko pk) {
        StringBuffer retval = new StringBuffer();
        String funcname = pk.getScopname();
        InputMemnames input = pk.getInput();
        retval.append("-export([" + funcname + "/" + input.getSize() + "]).\n");
        return retval.toString();
    }

    public static String creErlfileTopRecode(ProcessKakko pk) {
        StringBuffer retval = new StringBuffer();
        StructtypeData std = new StructtypeData(pk.getStructdats());
        retval.append(std.toErlnagRecodeAll());
        return retval.toString();
    }

    public static String creErlfileTopSouce(ProcessKakko pk) {
        StringBuffer retval = new StringBuffer();
        retval.append("\n%-----------------------------------------------\n");
        retval.append(STUB_IMPORT);
        retval.append(GvaTblList);
        retval.append(pk.getInmems().getExtMemNameListCVS());
        retval.append("].\n\n");
        retval.append(GvalKeyList);
        retval.append(pk.getInmems().getExtMemKeysCVS());
        retval.append("].\n\n");
        retval.append(GvalDefList);
        retval.append(pk.getInmems().getExtMemDefCVS());
        retval.append("].\n\n");
        retval.append(INITVAL);
        retval.append("%-----------------------------------------------\n");
        return retval.toString();
    }

    public String creErlSource(ProcessKakko pk) {
        this.output = new ElementOutput(pk);
        String funcname = pk.getScopname();
        ProcessBlockMarge marg = new ProcessBlockMarge(funcname, 0);
        EditBuffer retval = new EditBuffer();
        marg = this.crePBMarge(marg);
        this.creParFunc(marg, retval, pk);
        int i = 1;
        while (true) {
            marg.clearPB();
            marg.chgNest(i);
            marg = this.crePBMarge(marg);
            if (!marg.first()) break;
            this.sepaFunc(marg, retval);
            ++i;
        }
        return retval.toString();
    }

    private void creParFunc(ProcessBlockMarge marg, EditBuffer retval, ProcessKakko pk) {
        String funcname = pk.getScopname();
        InputMemnames input = pk.getInput();
        this.output.clean();
        this.output.clearRamdPara();
        ErlangCreator.getFuncTop(funcname, input.toErlang(this.output), retval);
        ErlangCreator.appendPFuncBody(funcname, retval);
        ErlangCreator.creFuncTopWhenArrayUse(retval, funcname, pk.getInmems());
        marg.getPFuncCallList(this.output, retval);
    }

    private ProcessBlockMarge crePBMarge(ProcessBlockMarge marg) {
        int rtno;
        ProcessBlock[] pbs;
        this.routes.first();
        while (this.routes.hasNext() && marg.putPB(pbs = this.routes.getRouteProBlocks(rtno = this.routes.next()))) {
        }
        return marg;
    }

    private void sepaFunc(ProcessBlockMarge marg, EditBuffer retval) {
        marg.getBasicFunc(retval, this.output);
        marg.getStructFunc(retval, this.output);
        marg.getLoopFunc(retval, this.output);
    }

    public static void getFuncTop(String funcname, String input, EditBuffer retval) {
        retval.append(funcname + "(" + input + ")->");
        retval.setLineEndN();
        retval.incNest();
    }

    public static void getFuncTopLoop(String funcname, String bbinput, String taple, String guard, EditBuffer retval) {
        retval.append(funcname + "@_loop(" + bbinput + ")  ->");
        retval.setLineEndN();
        retval.incNest();
        retval.append("case " + bbinput + " of");
        retval.setLineEndN();
        retval.incNest();
        retval.append(taple + " when " + guard + " ->");
        retval.setLineEndN();
        retval.incNest();
    }

    public static void getFunLoopRecus(String funcname, String taple, EditBuffer retval) {
        retval.append(funcname + "@_loop(" + taple + ")");
        retval.savNest();
        retval.setLineEndSN();
        retval.recoverNest();
        retval.decNest();
    }

    public static void getFuncEndLoop(String funcname, String intaple, String rettaple, EditBuffer retval) {
        retval.append(intaple + "->");
        retval.setLineEndN();
        retval.incNest();
        retval.append(rettaple);
        retval.setLineEndN();
        retval.decNest();
        retval.append("end");
        retval.setFuncEnd();
    }

    public static void getFuncEndLoop_SMP(String funcname, String intaple, String rettaple, EditBuffer retval) {
        retval.append(intaple + "->");
        retval.setLineEndN();
        retval.incNest();
        retval.append("process_flag(trap_exit,true)");
        retval.setLineEndKN();
        retval.append(funcname + "@_loop_smp(0,Input)");
        retval.setLineEndN();
        retval.decNest();
        retval.append("end");
        retval.setFuncEnd();
    }

    public static void getFuncSMP_Recfunc(String funcname, String guard, EditBuffer retval) {
        retval.append(funcname + "@_loop_smp(I,Retval)  ->");
        retval.setLineEndN();
        retval.incNest();
        retval.append("case I of");
        retval.setLineEndN();
        retval.incNest();
        retval.append(" I when " + guard + " ->");
        retval.setLineEndN();
        retval.incNest();
        retval.append("receive");
        retval.setLineEndN();
        retval.incNest();
        retval.append("_  ->");
        retval.incNest();
        retval.setLineEndN();
        retval.append(funcname + "@_loop_smp(I + 1,Retval)");
        retval.decNest();
        retval.decNest();
        retval.setLineEndN();
        retval.append("end");
        retval.savNest();
        retval.setLineEndSN();
        retval.recoverNest();
        retval.decNest();
        retval.append("_  ->");
        retval.incNest();
        retval.setLineEndN();
        retval.incNest();
        retval.append("Retval");
        retval.setLineEndN();
        retval.decNest();
        retval.append("end");
        retval.setFuncEnd();
    }

    public static void getFuncTopStru(String funcname, String input, EditBuffer retval) {
        retval.append(funcname + "@Struct(" + input + ")->");
        retval.setLineEndN();
        retval.incNest();
    }

    public static void getFuncTopBB(String funcname, String input, EditBuffer retval) {
        if (input == null || input.length() == 0) {
            retval.append(funcname + "() -> ");
        } else {
            retval.append(funcname + "( " + input + " )  -> ");
        }
        retval.setLineEndN();
        retval.incNest();
    }

    public static void getFuncTopSTBB(String funcname, String input, int caseno, EditBuffer retval) {
        if (input == null || input.length() == 0) {
            retval.append(funcname + "(Case) when Case =:= " + caseno + " -> ");
        } else {
            retval.append(funcname + "( " + input + ",Case) when Case =:= " + caseno + " -> ");
        }
        retval.setLineEndN();
        retval.incNest();
    }

    public static void getBBFuncCallLine(String funcname, String basicinput, EditBuffer retval) {
        if (basicinput == null || basicinput.length() == 0) {
            retval.append(funcname + "()");
        } else {
            retval.append(funcname + "(" + basicinput + ")");
        }
        retval.setLineEndKN();
    }

    public static void getBSFuncCallLine(String funcname, String basicinput, String structinput, EditBuffer retval) {
        if (basicinput == null || basicinput.length() == 0) {
            retval.append(funcname + "(" + funcname + "@Struct(" + structinput + "))");
        } else {
            retval.append(funcname + "(" + basicinput + " , " + funcname + "@Struct(" + structinput + "))");
        }
        retval.setLineEndKN();
    }

    public static void getLoopFuncCallLine(String funcname, String basicinput, String rettpl, EditBuffer retval) {
        retval.append(rettpl + " = " + funcname + "@_loop" + "(" + basicinput + ")");
        retval.setLineEndKN();
    }

    public static void getLoopFuncCallLineSMP(String funcname, String basicinput, EditBuffer retval) {
        retval.append("spawn_link( fun()-> " + funcname + "@_loop" + "(" + basicinput + ") end)");
        retval.setLineEndKN();
    }

    public static void appendPFuncBody(String funcname, EditBuffer retval) {
        if (funcname.equals("main")) {
            retval.append("initval()");
            retval.setLineEndKN();
        }
    }

    public static String valCToErl(String val) {
        if (val.length() == 0) {
            return val;
        }
        String after = val.substring(1);
        String bef = val.substring(0, 1);
        bef = bef.toUpperCase();
        return bef + after;
    }

    public static String cnvertNum(String num) {
        if (num.length() < 2) {
            return num;
        }
        if (num.charAt(0) != '0') {
            return num;
        }
        if (num.charAt(1) != 'x') {
            return num;
        }
        return "16#" + num.substring(2);
    }
}

