/*
 * Decompiled with CFR 0.152.
 */
package analyzecodeC.erlang;

import analyzecodeC.AnalyzeCodeCM;
import analyzecodeC.decode.BasicBlock;
import analyzecodeC.decode.LoopBlock;
import analyzecodeC.decode.ProcessBlock;
import analyzecodeC.decode.StructBlock;
import analyzecodeC.erlang.EditBuffer;
import analyzecodeC.erlang.Element;
import analyzecodeC.erlang.ElementOutput;
import analyzecodeC.erlang.ErlangCreator;
import analyzecodeC.erlang.InputMemnames;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;

public class ProcessBlockMarge
implements Serializable {
    private static final long serialVersionUID = 201002060026000001L;
    private String funcname;
    private Pbset[] pbset;
    private int counter = 0;
    private int panest = 0;
    private int chnest = 1;

    public ProcessBlockMarge(String fname) {
        this.funcname = fname;
    }

    public ProcessBlockMarge(String fname, int pnest) {
        this.funcname = fname;
        this.panest = pnest;
        this.chnest = pnest + 1;
    }

    public void chgNest(int pnest) {
        this.panest = pnest;
        this.chnest = pnest + 1;
    }

    public boolean first() {
        this.counter = 0;
        return this.pbset != null && this.pbset.length > 0;
    }

    public boolean hasNext() {
        return this.pbset != null && this.pbset.length > this.counter;
    }

    public int next() {
        int retval = this.counter++;
        return retval;
    }

    public int getNest() {
        return this.pbset[this.counter].getNest();
    }

    public String getLoopFunc(EditBuffer retval, ElementOutput output) {
        String nfname;
        LoopBlock btype;
        int top = -1;
        boolean chsmp = false;
        for (int i = 0; i < this.pbset.length; ++i) {
            if (top < 0) {
                btype = this.pbset[i].getLoopBlock();
                if (btype == null) continue;
                nfname = this.funcname + this.pbset[i].getMyname();
                if (this.pbset[i].getNest() != this.panest) continue;
                output.clean();
                output.clearRamdPara();
                btype.getFuncBodyTop(nfname, output, retval);
                BasicBlock bb = this.pbset[i].getBasicBlock();
                if (bb == null) continue;
                bb.getFuncBody(output, retval, false);
                top = i;
                continue;
            }
            if (this.pbset[i].getNest() != this.chnest) {
                btype = this.pbset[top].getLoopBlock();
                nfname = this.funcname + this.pbset[top].getMyname();
                btype.getFuncBodyEnd(nfname, output, retval, chsmp);
                output.clearRamdPara();
                top = -2;
                --i;
                chsmp = false;
                continue;
            }
            chsmp = this.pbset[i].getSMP_Flg() && AnalyzeCodeCM.AUTO_SMP;
            this.pbset[i].getParentCodeCallLoop(output, retval, chsmp);
        }
        if (top == -1 || top == -2) {
            return retval.toString();
        }
        int idx = top < 0 ? this.pbset.length - 1 : top;
        btype = this.pbset[idx].getLoopBlock();
        nfname = this.funcname + this.pbset[idx].getMyname();
        btype.getFuncBodyEnd(nfname, output, retval, chsmp);
        output.clearRamdPara();
        return retval.toString();
    }

    public String getStructFunc(EditBuffer retval, ElementOutput output) {
        for (int i = 0; i < this.pbset.length; ++i) {
            StructBlock btype;
            if (this.pbset[i].getNest() != this.panest || this.pbset[i].isLoop() || (btype = this.pbset[i].getStructBlock()) == null) continue;
            String nfname = this.funcname + this.pbset[i].getMyname();
            output.clean();
            output.clearRamdPara();
            btype.getFuncBodyTop(nfname, output, retval);
            btype.getFuncBody(retval, output);
        }
        return retval.toString();
    }

    public String getBasicFunc(EditBuffer retval, ElementOutput output) {
        boolean chsmp = false;
        for (int i = 0; i < this.pbset.length; ++i) {
            if (this.pbset[i].getNest() != this.panest || this.pbset[i].isLoop()) continue;
            this.basicFuncBody(this.pbset[i], retval, output);
        }
        return retval.toString();
    }

    private boolean basicFuncBody(Pbset pbsetin, EditBuffer retval, ElementOutput output) {
        boolean ret = false;
        int size = pbsetin.setCaseno();
        String nfname = this.panest == 0 ? this.funcname : this.funcname + pbsetin.getMyname();
        for (int i = pbsetin.pbs.length - 1; i >= 0; --i) {
            BasicBlock bb = pbsetin.getBasicBlock(i);
        }
        InputMemnames input = pbsetin.getMargeBasicBlockInput();
        for (int i = pbsetin.pbs.length - 1; i >= 0; --i) {
            output.clean();
            output.clearRamdPara();
            BasicBlock bb = pbsetin.getBasicBlock(i);
            if (bb == null) continue;
            ret = true;
            bb.setInput(input);
            boolean creb = false;
            output.clean();
            output.clearRamdPara();
            bb.getFuncBodyTop(nfname, output, retval);
            creb |= bb.getFuncBody(output, retval, true);
            ProcessBlock pb = pbsetin.pbs[i].getChildnest();
            if (pb != null) {
                Pbset tmp = new Pbset(pb);
                tmp.nameno = pb.getBlockno();
                boolean chsmp = tmp.getSMP_Flg() && AnalyzeCodeCM.AUTO_SMP;
                tmp.getParentCodeCallLoop(output, retval, chsmp);
            }
            if (!creb) {
                retval.append("-------IGNOR--------");
            }
            retval.setLineEndSN();
        }
        if (pbsetin.pbs.length == 1 && pbsetin.pbs[0].isCondition()) {
            BasicBlock bb = new BasicBlock();
            bb.setCasenos(2);
            bb.getFuncBodyTop(nfname, output, retval);
            bb.addLine(new Element("false"));
            bb.getFuncBody(output, retval, true);
            retval.setLineEndSN();
        }
        retval.setFuncEnd();
        return ret;
    }

    public String getPFuncCallList(ElementOutput output, EditBuffer retval) {
        int top = -1;
        boolean chsmp = false;
        for (int i = 0; i < this.pbset.length; ++i) {
            boolean ramdaend;
            boolean bl = ramdaend = this.pbset.length == i + 1 || this.pbset[i + 1].getNest() != this.chnest;
            if (this.pbset[i].getNest() == this.panest) {
                BasicBlock bb = this.pbset[i].getBasicBlock();
                if (bb == null || !bb.getFuncBody(output, retval, ramdaend)) continue;
                top = i;
                continue;
            }
            boolean bl2 = chsmp = this.pbset[i].getSMP_Flg() && this.panest != 0 && AnalyzeCodeCM.AUTO_SMP;
            if (this.pbset[i].getNest() != this.chnest) {
                top = -2;
                --i;
                chsmp = false;
                continue;
            }
            this.pbset[i].getParentCodeCallLoop(output, retval, chsmp);
        }
        if (top != -1) {
            retval.setFuncEnd();
        }
        return retval.toString();
    }

    private void crePbset(ProcessBlock[] pbs) {
        this.pbset = new Pbset[pbs.length];
        for (int i = 0; i < this.pbset.length; ++i) {
            this.pbset[i] = new Pbset(pbs[i]);
            this.pbset[i].nameno = pbs[i].getBlockno();
        }
    }

    private void addPbset(ProcessBlock pb) {
        Pbset[] work = new Pbset[this.pbset.length + 1];
        work[this.pbset.length] = new Pbset(pb);
        work[this.pbset.length].nameno = this.pbset.length;
        System.arraycopy(this.pbset, 0, work, 0, this.pbset.length);
        this.pbset = work;
    }

    public void clearPB() {
        this.pbset = null;
    }

    private void creInput(ProcessBlock[] pb) {
        block0: for (int idx = 0; idx < pb.length; ++idx) {
            int start = pb[idx].getNest();
            if (pb[idx].getAllinput() != null) continue;
            pb[idx].setAllinput(new InputMemnames());
            InputMemnames mkinput = pb[idx].getAllinput();
            this.addInputAllMemObjCBlock(mkinput, pb[idx]);
            for (int i = idx + 1; i < pb.length; ++i) {
                if (pb[i].getNest() > start) {
                    this.addInputAllMemObjCBlock(mkinput, pb[i]);
                    continue;
                }
                if (pb[i].getNest() != start || pb[i].isLoop() || pb[i].isCondition() || pb[i].isSwitch()) continue block0;
                this.addInputAllMemObjCBlock(mkinput, pb[i]);
            }
        }
    }

    private ProcessBlock[] cnvPbs(ProcessBlock[] pb) {
        ArrayList<ProcessBlock> pbs = new ArrayList<ProcessBlock>();
        boolean chkparent = false;
        for (int i = 0; i < pb.length; ++i) {
            if (pb[i].getNest() != this.panest && pb[i].getNest() != this.chnest) continue;
            if (pb[i].getNest() == this.panest) {
                chkparent = true;
            }
            pbs.add(pb[i]);
        }
        return pbs.toArray(new ProcessBlock[pbs.size()]);
    }

    public boolean putPB(ProcessBlock[] pbs) {
        ProcessBlock[] pb = this.cnvPbs(pbs);
        if (pb.length == 0) {
            return false;
        }
        if (this.pbset == null) {
            this.creInput(pbs);
            this.crePbset(pb);
            return true;
        }
        int start = 0;
        for (int i = 0; i < pb.length; ++i) {
            int same = this.srStartPoint(start, pb[i]);
            if (same < 0) {
                if (this.pbset.length <= start) {
                    this.addPbset(pb[i]);
                    ++start;
                    continue;
                }
                while (this.pbset[start].getNest() != pb[i].getNest()) {
                    if (++start < this.pbset.length) continue;
                    return true;
                }
                this.pbset[start++].addPb(pb[i]);
                continue;
            }
            if (start != same) {
                for (int j = start; j < same; ++j) {
                    this.pbset[j].addPb(null);
                }
                start = same;
                continue;
            }
            ++start;
        }
        return true;
    }

    private int srStartPoint(int start, ProcessBlock pb) {
        int i;
        for (i = start; i < this.pbset.length && !this.pbset[i].isEqPb(pb); ++i) {
        }
        if (i == this.pbset.length) {
            return -1;
        }
        return i;
    }

    private void addInputAllMemObjCBlock(InputMemnames inmput, ProcessBlock pb) {
        LoopBlock clb = pb.getLoopBlock();
        if (clb != null) {
            inmput.putInput(clb.getInput());
        }
        pb.getInput(inmput, true);
        pb.getInput(inmput, false);
    }

    public String toLog() {
        StringBuffer retval = new StringBuffer();
        retval.append("funcname=" + this.funcname + "\n");
        if (this.pbset == null) {
            retval.append("pbset null\n");
        } else {
            for (int i = 0; i < this.pbset.length; ++i) {
                retval.append("######Pbset[" + i + "]###########\n");
                retval.append(this.pbset[i].toLog());
            }
        }
        return retval.toString();
    }

    private class Pbset {
        private ProcessBlock[] pbs = new ProcessBlock[1];
        private int nameno = -1;
        private LoopBlock getloop;
        private StructBlock getsb;
        private BasicBlock[] getbb = new BasicBlock[1];

        private Pbset(ProcessBlock pb) {
            this.pbs[0] = pb;
        }

        private String toLog() {
            StringBuffer retval = new StringBuffer();
            for (int i = 0; i < this.pbs.length; ++i) {
                retval.append("ProcessBlock[" + i + "]\n");
                retval.append(this.pbs[i].toLog());
            }
            return retval.toString();
        }

        private boolean getParentCodeCallLoop(ElementOutput output, EditBuffer retval, boolean smp) {
            if (this.isLoop()) {
                String fname = ProcessBlockMarge.this.funcname + this.getMyname();
                LoopBlock lb = this.getLoopBlock();
                return lb.getCallFuncBody(fname, output, retval, smp);
            }
            return this.getBBSTcode(output, retval);
        }

        private boolean getBBSTcode(ElementOutput output, EditBuffer retval) {
            int size = this.setCaseno();
            InputMemnames inputb = this.getMargeBasicBlockInput();
            String fname = ProcessBlockMarge.this.funcname + this.getMyname();
            StructBlock sb = this.getStructBlock();
            if (sb == null) {
                ErlangCreator.getBBFuncCallLine(fname, inputb.toErlang(output), retval);
            } else {
                InputMemnames inputs = sb.getInput();
                ErlangCreator.getBSFuncCallLine(fname, inputb.toErlang(output), inputs.toErlang(output), retval);
            }
            return true;
        }

        private boolean isLoop() {
            return this.pbs[0].isLoop();
        }

        private boolean getSMP_Flg() {
            return this.pbs[0].chkSMP();
        }

        private int getNest() {
            return this.pbs[0].getNest();
        }

        private String getMyname() {
            return new Integer(this.nameno).toString();
        }

        private boolean isEqPb(ProcessBlock pb) {
            for (int i = 0; i < this.pbs.length; ++i) {
                if (this.pbs[i].getBlockno() != pb.getBlockno()) continue;
                return true;
            }
            return false;
        }

        private boolean addPb(ProcessBlock pb) {
            if (pb == null) {
                if (this.pbs[this.pbs.length - 1].getNest() < 0) {
                    return true;
                }
                pb = new ProcessBlock(-1, null);
            }
            if (this.pbs.length == 1 && this.pbs[0].isLoop()) {
                return false;
            }
            this.getsb = null;
            this.getbb = null;
            this.getloop = null;
            Object[] work = new ProcessBlock[this.pbs.length + 1];
            System.arraycopy(this.pbs, 0, work, 0, this.pbs.length);
            work[work.length - 1] = pb;
            Arrays.sort(work);
            this.pbs = work;
            this.getbb = new BasicBlock[this.pbs.length];
            return true;
        }

        private LoopBlock getLoopBlock() {
            if (!this.isLoop()) {
                return null;
            }
            if (this.getloop != null) {
                return this.getloop;
            }
            ProcessBlock looppb = this.pbs[0];
            this.getloop = looppb.getLoopBlock();
            this.getloop.addBBinput(looppb.getAllinput());
            return this.getloop;
        }

        private StructBlock getStructBlock() {
            if (this.getsb != null) {
                return this.getsb;
            }
            StructBlock retval = new StructBlock();
            InputMemnames input = new InputMemnames();
            if (this.pbs.length == 1) {
                if (this.pbs[0].getBlockno() < 0 || !this.pbs[0].isCondition()) {
                    return null;
                }
                this.pbs[0].getInput(input, true);
                this.pbs[0].getStructBlock(retval, 1);
                this.pbs[0].getStructBlockDefault(retval, 2);
            } else {
                for (int i = this.pbs.length - 1; i >= 0; --i) {
                    if (this.pbs[i].getBlockno() < 0) {
                        this.pbs[i].getStructBlockDefault(retval, i + 1);
                        continue;
                    }
                    this.pbs[i].getInput(input, true);
                    this.pbs[i].getStructBlock(retval, i + 1);
                }
            }
            if (retval.isEmptyLine()) {
                return null;
            }
            retval.setInput(input);
            this.getsb = retval;
            return retval;
        }

        private int setCaseno() {
            int i;
            int size = 0;
            for (i = 0; i < this.pbs.length; ++i) {
                ++size;
            }
            for (i = 0; i < this.pbs.length; ++i) {
                this.pbs[i].setCaseno(i);
            }
            return size;
        }

        private InputMemnames getMargeBasicBlockInput() {
            InputMemnames input = new InputMemnames();
            this.setCaseno();
            for (int i = 0; i < this.pbs.length; ++i) {
                if (this.pbs[i].getCaseno() < 0) continue;
                this.pbs[i].getInput(input, false);
            }
            return input;
        }

        private BasicBlock getBasicBlock() {
            for (int i = 0; i < this.pbs.length; ++i) {
                BasicBlock retval = this.getBasicBlock(i);
                if (retval == null) continue;
                return retval;
            }
            return null;
        }

        private BasicBlock getBasicBlock(int idx) {
            BasicBlock retval = null;
            int caseno = this.pbs[idx].getCaseno();
            if (caseno < 0) {
                throw new Error();
            }
            if (this.getbb[idx] != null) {
                return this.getbb[idx];
            }
            if (this.pbs[idx].getNest() < 0) {
                retval = new BasicBlock();
                retval.setCasenos(2);
                retval.addLine(new Element("false"));
            } else {
                retval = this.pbs[idx].getBasicBlock();
                if (retval == null) {
                    return null;
                }
            }
            retval.creInput();
            this.getbb[idx] = retval;
            return retval;
        }
    }
}

