/*
 * Cueplot: a GUI front end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "Plot.h"

const QString Plot::AXIS[] = {
	"x1y1", "x2y2", "x1y2", "x2y1", ""
};

Plot::Plot() : isFunction_(true), axis_(-1)
{
}

void Plot::setRange(const PlotRange &range)
{
	range_ = range;
}

const PlotRange &Plot::range() const
{
	return range_;
}

void Plot::setFunction(bool isFunction)
{
	isFunction_ = isFunction;
}

bool Plot::isFunction() const
{
	return isFunction_;
}

void Plot::setFunction(const QString &name)
{
	function_ = name;
}

const QString &Plot::function() const
{
	return function_;
}

void Plot::setDataFile(const QString &name)
{
	dataFile_ = name;
}

const QString &Plot::dataFile() const
{
	return dataFile_;
}

void Plot::setDataFileModifier(const PlotModifier &mod)
{
	dataFileModifier_ = mod;
}

const PlotModifier &Plot::dataFileModifier() const
{
	return dataFileModifier_;
}

void Plot::setAxis(int axis)
{
	axis_ = axis;
}

int Plot::axis() const
{
	return axis_;
}

void Plot::setTitleSpecification(const PlotTitle &title)
{
	titleSpecification_ = title;
}

const PlotTitle &Plot::titleSpecification() const
{
	return titleSpecification_;
}

void Plot::setStyle(const PlotStyle &style)
{
	style_ = style;
}

const PlotStyle &Plot::style() const
{
	return style_;
}

QString Plot::command() const
{
	QString str = range_.option() + " ";
	if (isFunction_) {
		str = function_;
	} else {
		str = "\"" + dataFile_ + "\" " + dataFileModifier_.option();
	}
	str += " ";
	if (axis_ >= 0) {
		str += "axes " + AXIS[axis_] + " ";
	}
	str += titleSpecification_.option();
	str += " ";
	str += style_.option();

	return str.trimmed();
}
