/*
 * Cueplot: a GUI front end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef PLOT_OPTION_DIALOG_INCLUDED
#define PLOT_OPTION_DIALOG_INCLUDED

class Plot;
class PlotModifierWidget;
class PlotOthersWidget;
class PlotStyleWidget;
class PlotTitleWidget;

#include <QDialog>
class QListWidget;
class QListWidgetItem;
class QStackedWidget;

class PlotOptionDialog : public QDialog
{
	Q_OBJECT

	public:
		PlotOptionDialog(QWidget *parent = 0);

		void setPlot(Plot &plot);

	private slots:
		void accept();
		void apply();
		void plot();
		void splot();
		void changePage(QListWidgetItem *current, QListWidgetItem *previous);

	signals:
		void executed(const QString &);

	private:
		// don't implement these
		PlotOptionDialog(const PlotOptionDialog &);
		PlotOptionDialog &operator=(const PlotOptionDialog &);

		Plot *plot_;
		QStackedWidget *pagesStackedWidget;
		QListWidget *contentsListWidget;
		PlotModifierWidget *plotModifierWidget;
		PlotOthersWidget *plotOthersWidget;
		PlotTitleWidget *plotTitleWidget;
		PlotStyleWidget *plotStyleWidget;
};
#endif // PLOT_OPTION_DIALOG_INCLUDED
