/*
 * Cueplot: a GUI front end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "FitOthersWidget.h"

#include <QDoubleSpinBox>
#include <QLabel>
#include <QGroupBox>
#include <QGridLayout>
#include <QVBoxLayout>

#include <cmath> // pow(), floor()

FitOthersWidget::FitOthersWidget(QWidget *parent)
: QWidget(parent)
{
	setWindowTitle(tr("Others"));

	QLabel *fitLimitLabel = new QLabel;
	fitLimitLabel->setText(tr("Fit Limit:"));

	fitLimitMantissaDoubleSpinBox = new QDoubleSpinBox;

	QLabel *fitLimitMiddleLabel = new QLabel;
	fitLimitMiddleLabel->setText(" x 10^");

	fitLimitExponentSpinBox = new QSpinBox;
	fitLimitExponentSpinBox->setMinimum(-99);
	fitLimitExponentSpinBox->setMaximum(0);

	QLabel *fitMaxIterLabel = new QLabel;
	fitMaxIterLabel->setText(tr("Fit Max Iterations:"));

	fitMaxIterSpinBox = new QSpinBox;

	QGridLayout *svLayout = new QGridLayout;
	svLayout->addWidget(fitLimitLabel, 0, 0);
	svLayout->addWidget(fitLimitMantissaDoubleSpinBox, 0, 1);
	svLayout->addWidget(fitLimitMiddleLabel, 0, 2);
	svLayout->addWidget(fitLimitExponentSpinBox, 0, 3);
	svLayout->addItem(new QSpacerItem(40, 20,
				QSizePolicy::Expanding, QSizePolicy::Minimum), 0, 4);
	svLayout->addWidget(fitMaxIterLabel, 1, 0);
	svLayout->addWidget(fitMaxIterSpinBox, 1, 1);

	QGroupBox *svGroupBox = new QGroupBox(tr("Special Variables"));
	svGroupBox->setLayout(svLayout);

	QVBoxLayout *mainLayout = new QVBoxLayout;
	mainLayout->setMargin(0);
	mainLayout->addWidget(svGroupBox);
	mainLayout->addStretch();

	setLayout(mainLayout);
}

void FitOthersWidget::setFitLimit(double limit)
{
	int limitExponent = static_cast<int>(floor(log10(limit)));
	fitLimitExponentSpinBox->setValue(limitExponent);
	double limitMantissa = limit / pow(10, limitExponent);
	fitLimitMantissaDoubleSpinBox->setValue(limitMantissa);
}

double FitOthersWidget::fitLimit() const
{
	return fitLimitMantissaDoubleSpinBox->value()
			* pow(10, fitLimitExponentSpinBox->value());
}

void FitOthersWidget::setFitMaxIter(int iter)
{
	fitMaxIterSpinBox->setValue(iter);
}

int FitOthersWidget::fitMaxIter() const
{
	return fitMaxIterSpinBox->value();
}
