/*
 * Cueplot: a GUI front end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "BarOptionWidget.h"
#include "Bar.h"

#include <QComboBox>
#include <QDoubleSpinBox>
#include <QGridLayout>
#include <QRadioButton>

BarOptionWidget::BarOptionWidget (QWidget *parent)
: OptionWidget(parent)
{
	setWindowTitle(tr("Bar Size"));
}

void BarOptionWidget::construct() 
{
	barSizeRadioButton = new QRadioButton;
	barSizeRadioButton->setText(tr("Quantitative"));

	barSizeDoubleSpinBox = new QDoubleSpinBox;
	connect(barSizeRadioButton, SIGNAL(toggled(bool)),
			barSizeDoubleSpinBox, SLOT(setEnabled(bool)));

	synRadioButton = new QRadioButton;
	synRadioButton->setText(tr("Qualitative"));

	synComboBox = new QComboBox;
	synComboBox->addItem(tr("small"));
	synComboBox->addItem(tr("large"));
	connect(synRadioButton, SIGNAL(toggled(bool)),
			synComboBox, SLOT(setEnabled(bool)));

	QGridLayout *mainLayout = new QGridLayout;
	mainLayout->addWidget(barSizeRadioButton, 0, 0);
	mainLayout->addWidget(barSizeDoubleSpinBox, 0, 1);
	mainLayout->addItem(new QSpacerItem(40, 20, 
				QSizePolicy::Expanding, QSizePolicy::Minimum), 0, 2);
	mainLayout->addWidget(synRadioButton, 1, 0);
	mainLayout->addWidget(synComboBox, 1, 1);
	mainLayout->addItem(new QSpacerItem(20, 40,
				QSizePolicy::Minimum, QSizePolicy::Expanding), 2, 0);

	setLayout(mainLayout);
}

void BarOptionWidget::init()
{
	Bar bar;
	if (bar.isSmall() || bar.isBig()) {
		synComboBox->setCurrentIndex(static_cast<int>(bar.size()));
		synRadioButton->setChecked(true);
		barSizeDoubleSpinBox->setEnabled(false);
	} else {
		barSizeRadioButton->setChecked(true);
		synComboBox->setEnabled(false);
	}
	barSizeDoubleSpinBox->setValue(bar.size());
}

void BarOptionWidget::apply()
{
	Bar bar;
	if (synRadioButton->isChecked()) {
		bar.setSize(synComboBox->currentIndex());
	} else {
		bar.setSize(barSizeDoubleSpinBox->value());
	}
	emit executed(bar.command());
}
