/*
 * Cueplot: a GUI front end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "DummyOptionWidget.h"
#include "Dummy.h"

#include <QGridLayout>
#include <QLabel>
#include <QLineEdit>

DummyOptionWidget::DummyOptionWidget(QWidget *parent)
: OptionWidget(parent)
{
	setWindowTitle(tr("Dummy Variable"));
}

void DummyOptionWidget::construct()
{
	QLabel *varLabel[AXIS_NUM];
	const QString DUMMY[] = { "&X", "&Y" };
	for (int i = 0; i < AXIS_NUM; i++) {
		dummyLineEdit[i] = new QLineEdit;

		varLabel[i] = new QLabel;
		varLabel[i]->setText(
				tr("Variable") + " " + DUMMY[i] + ":");
		varLabel[i]->setBuddy(dummyLineEdit[i]);
	}

	QGridLayout *mainLayout = new QGridLayout;
	for (int i = 0; i < AXIS_NUM; i++) {
		mainLayout->addWidget(varLabel[i], i, 0);
		mainLayout->addWidget(dummyLineEdit[i], i, 1);
	}
	mainLayout->addItem(new QSpacerItem(40, 20, 
				QSizePolicy::Expanding, QSizePolicy::Minimum), 0, 2);
	mainLayout->addItem(new QSpacerItem(20, 40,
				QSizePolicy::Minimum, QSizePolicy::Expanding), AXIS_NUM, 0);

	setLayout(mainLayout);
}

void DummyOptionWidget::init()
{
	Dummy dummy;
	dummyLineEdit[0]->setText(dummy.dummyVar1());
	dummyLineEdit[1]->setText(dummy.dummyVar2());
}

void DummyOptionWidget::apply()
{
	// save x and y variable names
	Dummy dummy;
	dummy.setDummyVar1(dummyLineEdit[0]->text());
	dummy.setDummyVar2(dummyLineEdit[1]->text());
	emit executed(dummy.command());
}
