/*
 * Cueplot: a GUI front end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "LabelOptionWidget.h"
#include "Label.h"

#include <QComboBox>
#include <QDoubleSpinBox>
#include <QLabel>
#include <QLineEdit>
#include <QGridLayout>
#include <QStackedWidget>

LabelOptionWidget::LabelOptionWidget(QWidget *parent)
: OptionWidget(parent)
{
	setWindowTitle(tr("Label"));
}

void LabelOptionWidget::construct()
{
	axisComboBox = new QComboBox;
	const QString LABEL[] = { "X", "Y", "Z" };
	for (int i = 0; i < AXIS_NUM; i++) {
		axisComboBox->addItem(i ?
				LABEL[i - 1] + tr(" Label") : tr("Title"));
	}

	QLabel *axisLabel = new QLabel;
	axisLabel->setText(tr("&Title and Label:"));
	axisLabel->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);
	axisLabel->setBuddy(axisComboBox);

	labelStackedWidget = new QStackedWidget;

	QWidget *widget[AXIS_NUM];
	for (int i = 0; i < AXIS_NUM; i++) {
		widget[i] = new QWidget;
		setWidget(*widget[i], i);
		labelStackedWidget->addWidget(widget[i]);
	}
	connect(axisComboBox, SIGNAL(activated(int)),
			labelStackedWidget, SLOT(setCurrentIndex(int)));

	QHBoxLayout *selectLayout = new QHBoxLayout;
	selectLayout->addWidget(axisLabel);
	selectLayout->addWidget(axisComboBox);

	QVBoxLayout *mainLayout = new QVBoxLayout;
	mainLayout->addLayout(selectLayout);
	mainLayout->addWidget(labelStackedWidget);
	mainLayout->addStretch();
	setLayout(mainLayout);
}

void LabelOptionWidget::init()
{
	Label label;
	for (int i = 0; i < AXIS_NUM; i++) {
		labelLineEdit[i]->setText(label.label(i));
		xOffsetDoubleSpinBox[i]->setValue(label.xOffset(i));
		yOffsetDoubleSpinBox[i]->setValue(label.yOffset(i));
		fontNameLineEdit[i]->setText(label.fontName(i));
	}
}

void LabelOptionWidget::apply()
{
	Label label;
	// set x,y,z axis labels and title
	for (int i = 0; i < AXIS_NUM; i++) {
		label.setLabel(i, labelLineEdit[i]->text());
		label.setXOffset(i, xOffsetDoubleSpinBox[i]->value());
		label.setYOffset(i, yOffsetDoubleSpinBox[i]->value());
		label.setFontName(i, fontNameLineEdit[i]->text());
	}
	emit executed(label.command());
}

void LabelOptionWidget::setWidget(QWidget &widget, int index)
{
	labelLineEdit[index] = new QLineEdit;

	QLabel *textLabel = new QLabel;
	textLabel->setText(tr("T&ext:"));
	textLabel->setBuddy(labelLineEdit[index]);

	xOffsetDoubleSpinBox[index] = new QDoubleSpinBox;
	xOffsetDoubleSpinBox[index]->setMinimum(-99);

	QLabel *xOffsetLabel = new QLabel;
	xOffsetLabel->setText(tr("&X Offset:"));
	xOffsetLabel->setBuddy(xOffsetDoubleSpinBox[index]);

	yOffsetDoubleSpinBox[index] = new QDoubleSpinBox;
	yOffsetDoubleSpinBox[index]->setMinimum(-99);

	QLabel *yOffsetLabel = new QLabel;
	yOffsetLabel->setText(tr("&Y Offset:"));
	yOffsetLabel->setBuddy(yOffsetDoubleSpinBox[index]);

	fontNameLineEdit[index] = new QLineEdit;

	QLabel *fontNameLabel = new QLabel;
	fontNameLabel->setText(tr("&Font Name:"));
	fontNameLabel->setBuddy(fontNameLineEdit[index]);

	QGridLayout *mainLayout = new QGridLayout;
	mainLayout->addWidget(textLabel, 0, 0);
	mainLayout->addWidget(labelLineEdit[index], 0, 1, 1, 2);
	mainLayout->addWidget(xOffsetLabel, 1, 0);
	mainLayout->addWidget(xOffsetDoubleSpinBox[index], 1, 1);
	mainLayout->addItem(new QSpacerItem(40, 20,
				QSizePolicy::Expanding, QSizePolicy::Minimum), 1, 2);
	mainLayout->addWidget(yOffsetLabel, 2, 0);
	mainLayout->addWidget(yOffsetDoubleSpinBox[index], 2, 1);
	mainLayout->addWidget(fontNameLabel, 3, 0);
	mainLayout->addWidget(fontNameLineEdit[index], 3, 1, 1, 2);

	widget.setLayout(mainLayout);
}


