/*
 * Cueplot: a GUI front end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "LatexEmtexOptionWidget.h"
#include "LatexEmtex.h"

#include <QComboBox>
#include <QGridLayout>
#include <QLabel>
#include <QSpinBox>

LatexEmtexOptionWidget::LatexEmtexOptionWidget(QWidget *parent)
: OptionWidget(parent)
{
	setWindowTitle(tr("LaTeX/EmTeX"));
}

void LatexEmtexOptionWidget::construct()
{
	latexComboBox = new QComboBox;
	latexComboBox->addItem("LaTeX");
	latexComboBox->addItem("emTeX");

	fontNameComboBox = new QComboBox;
	fontNameComboBox->addItem("default");
	fontNameComboBox->addItem("roman");
	fontNameComboBox->addItem("courier");

	QLabel *fontNameLabel = new QLabel;
	fontNameLabel->setText(tr("&Font:"));
	fontNameLabel->setBuddy(fontNameComboBox);

	fontSizeSpinBox = new QSpinBox;

	QLabel *fontSizeLabel = new QLabel;
	fontSizeLabel->setText(tr("&Size:"));
	fontSizeLabel->setBuddy(fontSizeSpinBox);

	QGridLayout *mainLayout = new QGridLayout;
	mainLayout->addWidget(latexComboBox, 0, 0, 1, 3);
	mainLayout->addWidget(fontNameLabel, 1, 0);
	mainLayout->addWidget(fontNameComboBox, 1, 1);
	mainLayout->addItem(new QSpacerItem(40, 20, 
				QSizePolicy::Expanding, QSizePolicy::Minimum), 1, 2);
	mainLayout->addWidget(fontSizeLabel, 2, 0);
	mainLayout->addWidget(fontSizeSpinBox, 2, 1);
	mainLayout->addItem(new QSpacerItem(20, 40,
				QSizePolicy::Minimum, QSizePolicy::Expanding), 3, 0);

	setLayout(mainLayout);
}

void LatexEmtexOptionWidget::init()
{
	LatexEmtex latexEmtex;
	latexComboBox->setCurrentIndex(!latexEmtex.isLatex());
	fontNameComboBox->setCurrentIndex(latexEmtex.fontName());
	fontSizeSpinBox->setValue(latexEmtex.fontSize());
}

void LatexEmtexOptionWidget::apply()
{
	// set options
	LatexEmtex latexEmtex;

	latexEmtex.setLatex(!latexComboBox->currentIndex());
	latexEmtex.setFontName(fontNameComboBox->currentIndex());
	latexEmtex.setFontSize(fontSizeSpinBox->value());

	emit executed(latexEmtex.command());
}
