/*
 * Cueplot: a GUI front end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "LogScaleOptionWidget.h"
#include "LogScale.h"

#include <QCheckBox>
#include <QGridLayout>
#include <QLineEdit>

LogScaleOptionWidget::LogScaleOptionWidget(QWidget *parent)
: OptionWidget(parent)
{
	setWindowTitle(tr("Log Scale"));
}

void LogScaleOptionWidget::construct()
{
	const QString AXIS[] = { "X", "Y", "Z", "X2", "Y2" };
	for (int i = 0; i < TICS_NUM; i++) {
		logScaleCheckBox[i] = new QCheckBox;
		logScaleCheckBox[i]->setText(AXIS[i] + tr(" Axis"));

		baseLineEdit[i] = new QLineEdit;
		connect(logScaleCheckBox[i], SIGNAL(toggled(bool)),
				baseLineEdit[i], SLOT(setEnabled(bool)));
	}

	QGridLayout *mainLayout = new QGridLayout;
	for (int i = 0; i < TICS_NUM; i++) {
		mainLayout->addWidget(logScaleCheckBox[i], i, 0);
		mainLayout->addWidget(baseLineEdit[i], i, 1);
	}
	mainLayout->addItem(new QSpacerItem(40, 20, 
				QSizePolicy::Expanding, QSizePolicy::Minimum), 0, 2);
	mainLayout->addItem(new QSpacerItem(20, 40,
				QSizePolicy::Minimum, QSizePolicy::Expanding),
			TICS_NUM, 0);

	setLayout(mainLayout);
}

void LogScaleOptionWidget::init()
{
	LogScale logScale;
	for (int i = 0; i < TICS_NUM; i++) {
		logScaleCheckBox[i]->setChecked(logScale.isLogScale(i));
		baseLineEdit[i]->setEnabled(logScale.isLogScale(i));
		baseLineEdit[i]->setText(logScale.base(i));
	}
}
void LogScaleOptionWidget::apply()
{
	LogScale logScale;
	for (int i = 0; i < TICS_NUM; i++) {
		logScale.setLogScale(i, logScaleCheckBox[i]->isChecked());
		logScale.setBase(i, baseLineEdit[i]->text());
	}
	emit executed(logScale.command());
}
