/*
 * Cueplot: a GUI front end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef OPTION_WIDGET_INCLUDED
#define OPTION_WIDGET_INCLUDED

#include <QWidget>

class OptionWidget : public QWidget
{
	Q_OBJECT

	public:
		OptionWidget(QWidget *parent = 0);
		virtual ~OptionWidget();

		virtual void construct() = 0;

	public slots:
		virtual void init() = 0;
		virtual void apply() = 0;

	signals:
		void executed(const QString &command);

	private:
		// don't implement these
		OptionWidget(const OptionWidget &);
		OptionWidget &operator=(const OptionWidget &);
};

#endif // OPTION_WIDGET_INCLUDED
