/*
 * Cueplot: a GUI front end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "PbmOptionWidget.h"
#include "Pbm.h"

#include <QComboBox>
#include <QGridLayout>
#include <QLabel>

PbmOptionWidget::PbmOptionWidget(QWidget *parent)
: OptionWidget(parent)
{
	setWindowTitle(tr("PBM"));
}

void PbmOptionWidget::construct()
{
	fontSizeComboBox = new QComboBox;
	fontSizeComboBox->addItem(tr("small"));
	fontSizeComboBox->addItem(tr("medium"));
	fontSizeComboBox->addItem(tr("large"));

	QLabel *fontSizeLabel = new QLabel;
	fontSizeLabel->setText(tr("&Font Size:"));
	fontSizeLabel->setBuddy(fontSizeComboBox);

	colorModeComboBox = new QComboBox;
	colorModeComboBox->addItem(tr("monochrome"));
	colorModeComboBox->addItem(tr("gray"));
	colorModeComboBox->addItem(tr("color"));

	QLabel *colorModeLabel = new QLabel;
	colorModeLabel->setText(tr("Co&lormode:"));
	colorModeLabel->setBuddy(colorModeComboBox);

	QGridLayout *mainLayout = new QGridLayout;
	mainLayout->addWidget(fontSizeLabel, 0, 0);
	mainLayout->addWidget(fontSizeComboBox, 0, 1);
	mainLayout->addItem(new QSpacerItem(40, 20, 
				QSizePolicy::Expanding, QSizePolicy::Minimum), 0, 2);
	mainLayout->addWidget(colorModeLabel, 1, 0);
	mainLayout->addWidget(colorModeComboBox, 1, 1);
	mainLayout->addItem(new QSpacerItem(20, 40,
				QSizePolicy::Minimum, QSizePolicy::Expanding), 2, 0);

	setLayout(mainLayout);
}

void PbmOptionWidget::init()
{
	Pbm pbm;
	fontSizeComboBox->setCurrentIndex(pbm.fontSize());
	colorModeComboBox->setCurrentIndex(pbm.mode());
}

void PbmOptionWidget::apply()
{
	Pbm pbm;
	// get options
	pbm.setFontSize(fontSizeComboBox->currentIndex());
	pbm.setMode(colorModeComboBox->currentIndex());

	emit executed(pbm.command());
}
