/*
 * Cueplot: a GUI front end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "PostScriptOptionWidget.h"
#include "PostScript.h"

#include <QCheckBox>
#include <QComboBox>
#include <QLabel>
#include <QLineEdit>
#include <QGridLayout>
#include <QSpinBox>

PostScriptOptionWidget::PostScriptOptionWidget(QWidget *parent)
: OptionWidget(parent)
{
	setWindowTitle(tr("PostScript"));
}

void PostScriptOptionWidget::construct()
{
	modeComboBox = new QComboBox;
	modeComboBox->addItem(tr("landscape"));
	modeComboBox->addItem(tr("portrait"));
	modeComboBox->addItem("eps");

	QLabel *modeLabel = new QLabel;
	modeLabel->setText(tr("&Mode:"));
	modeLabel->setBuddy(modeComboBox);

	colorComboBox = new QComboBox;
	colorComboBox->addItem(tr("color"));
	colorComboBox->addItem(tr("monochrome"));

	QLabel *colorLabel = new QLabel;
	colorLabel->setText(tr("Co&lor:"));
	colorLabel->setBuddy(colorComboBox);

	solidComboBox = new QComboBox;
	solidComboBox->addItem(tr("solid"));
	solidComboBox->addItem(tr("dashed"));

	QLabel *solidLabel = new QLabel;
	solidLabel->setText(tr("Da&shed:"));
	solidLabel->setBuddy(solidComboBox);

	fontNameLineEdit = new QLineEdit;

	QLabel *fontNameLabel = new QLabel;
	fontNameLabel->setText(tr("&Font Name:"));
	fontNameLabel->setBuddy(fontNameLineEdit);

	fontSizeSpinBox = new QSpinBox;

	QLabel *fontSizeLabel = new QLabel;
	fontSizeLabel->setText(tr("Fo&nt Size:"));
	fontSizeLabel->setBuddy(fontSizeSpinBox);

	enhancedCheckBox = new QCheckBox;
	enhancedCheckBox->setText(tr("&Enhanced"));

	QGridLayout *mainLayout = new QGridLayout;
	mainLayout->addWidget(modeLabel, 0, 0);
	mainLayout->addWidget(modeComboBox, 0, 1);
	mainLayout->addItem(new QSpacerItem(40, 20, 
				QSizePolicy::Expanding, QSizePolicy::Minimum), 0, 2);
	mainLayout->addWidget(colorLabel, 1, 0);
	mainLayout->addWidget(colorComboBox, 1, 1);
	mainLayout->addWidget(solidLabel, 2, 0);
	mainLayout->addWidget(solidComboBox, 2, 1);
	mainLayout->addWidget(fontNameLabel, 3, 0);
	mainLayout->addWidget(fontNameLineEdit, 3, 1, 1, 2);
	mainLayout->addWidget(fontSizeLabel, 4, 0);
	mainLayout->addWidget(fontSizeSpinBox, 4, 1);
	mainLayout->addWidget(enhancedCheckBox, 5, 1);

	setLayout(mainLayout);
}

void PostScriptOptionWidget::init()
{
	PostScript postScript;
	modeComboBox->setCurrentIndex(postScript.mode());
	colorComboBox->setCurrentIndex(!postScript.isColor());
	solidComboBox->setCurrentIndex(!postScript.isSolid());
	fontNameLineEdit->setText(postScript.fontName());
	fontSizeSpinBox->setValue(postScript.fontSize());
	enhancedCheckBox->setChecked(postScript.enhances());
}

void PostScriptOptionWidget::apply()
{
	PostScript postScript;
	postScript.setMode(modeComboBox->currentIndex());
	postScript.setColor(!colorComboBox->currentIndex());
	postScript.setSolid(!solidComboBox->currentIndex());
	postScript.setEnhanced(enhancedCheckBox->isChecked());
	postScript.setFontName(fontNameLineEdit->text());
	postScript.setFontSize(fontSizeSpinBox->value());

	emit executed(postScript.command());
}
