/*
 * Cueplot: a GUI front end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef POST_SCRIPT_OPTION_WIDGET_INCLUDED
#define POST_SCRIPT_OPTION_WIDGET_INCLUDED

#include "OptionWidget.h"

class PostScript;

class QCheckBox;
class QComboBox;
class QLineEdit;
class QSpinBox;

class PostScriptOptionWidget : public OptionWidget
{
	Q_OBJECT

	public:
		PostScriptOptionWidget(QWidget *parent = 0);

		void construct();

	private:
		// don't implement these
		PostScriptOptionWidget(const PostScriptOptionWidget &);
		PostScriptOptionWidget &operator=(const PostScriptOptionWidget &);

		void init();
		void apply();
		QComboBox *modeComboBox;
		QComboBox *colorComboBox;
		QComboBox *solidComboBox;
		QLineEdit *fontNameLineEdit;
		QSpinBox *fontSizeSpinBox;
		QCheckBox *enhancedCheckBox;
};
#endif // POST_SCRIPT_OPTION_WIDGET_INCLUDED
