/*
 * Cueplot: a GUI front end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "RangeOptionWidget.h"
#include "Range.h"

#include <QLabel>
#include <QLineEdit>
#include <QGridLayout>

RangeOptionWidget::RangeOptionWidget(QWidget *parent)
: OptionWidget(parent)
{
	setWindowTitle(tr("Range"));
}

void RangeOptionWidget::construct()
{
	QLabel *minLabel = new QLabel;
	minLabel->setText(tr("Min"));

	QLabel *maxLabel = new QLabel;
	maxLabel->setText(tr("Max"));

	QLabel *varLabel[AXIS_NUM];
	const QString RANGE[] = { "X", "Y", "Z" };
	for (int i = 0; i < AXIS_NUM; i++) {
		varLabel[i] = new QLabel;
		varLabel[i]->setText(tr("Variable") + " " 
				+ RANGE[i] + ":");
		minLineEdit[i] = new QLineEdit;
		maxLineEdit[i] = new QLineEdit;
	}

	QGridLayout *mainLayout = new QGridLayout;
	mainLayout->addWidget(minLabel, 0, 1);
	mainLayout->addWidget(maxLabel, 0, 2);
	for (int i = 0; i < AXIS_NUM; i++) {
		int num = i + 1;
		mainLayout->addWidget(varLabel[i], num, 0);
		mainLayout->addWidget(minLineEdit[i], num, 1);
		mainLayout->addWidget(maxLineEdit[i], num, 2);
	}
	mainLayout->addItem(new QSpacerItem(20, 40,
				QSizePolicy::Minimum, QSizePolicy::Expanding),
			AXIS_NUM + 1, 0);

	setLayout(mainLayout);
}

void RangeOptionWidget::init()
{
	Range range;
	for (int i = 0; i < AXIS_NUM; i++) {
		minLineEdit[i]->setText(range.minimum(i));
		maxLineEdit[i]->setText(range.maximum(i));
	}
}

void RangeOptionWidget::apply()
{
	// save x,y,z ranges
	Range range;
	for (int i = 0; i < AXIS_NUM; i++) {
		range.setMinimum(i, minLineEdit[i]->text());
		range.setMaximum(i, maxLineEdit[i]->text());
	}
	emit executed(range.command());
}
