/*
 * Cueplot: a GUI front end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef TICS_OPTION_WIDGET_INCLUDED
#define TICS_OPTION_WIDGET_INCLUDED

#include "OptionWidget.h"

class Tics;

class QCheckBox;
class QComboBox;
class QGroupBox;
class QLineEdit;
class QRadioButton;
class QStackedWidget;
class QTabWidget;

class TicsOptionWidget : public OptionWidget
{
	Q_OBJECT

	public:
		TicsOptionWidget(QWidget *parent = 0);

		void construct();

	private:
		// don't implement these
		TicsOptionWidget(const TicsOptionWidget &);
		TicsOptionWidget &operator=(const TicsOptionWidget &);

		void init();
		void apply();
		void setWidget(QWidget &widget, int index);
		static const int TICS_NUM = 5;
		QComboBox *axisComboBox;
		QStackedWidget *ticsStackedWidget;
		QCheckBox *onCheckBox[TICS_NUM];
		QTabWidget *ticsTabWidget[TICS_NUM];
		QComboBox *locationComboBox[TICS_NUM];
		QCheckBox *mirrorCheckBox[TICS_NUM];
		QCheckBox *rotationCheckBox[TICS_NUM];
		QLineEdit *startPosLineEdit[TICS_NUM];
		QLineEdit *incPosLineEdit[TICS_NUM];
		QLineEdit *endPosLineEdit[TICS_NUM];
		QRadioButton *autofreqRadioButton[TICS_NUM];
		QRadioButton *sieRadioButton[TICS_NUM];
		QRadioButton *labelPosRadioButton[TICS_NUM];
		QLineEdit *labelsPosLineEdit[TICS_NUM];
		QGroupBox *posGroupBox[TICS_NUM];
};
#endif // TICS_OPTION_WIDGET_INCLUDED
