/*
 * Cueplot: a GUI front end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "PlotOthersWidget.h"
#include "Plot.h"

#include <QComboBox>
#include <QGroupBox>
#include <QHBoxLayout>
#include <QVBoxLayout>

PlotOthersWidget::PlotOthersWidget(QWidget *parent)
: QWidget(parent)
{
	setWindowTitle(tr("Others"));

	axisComboBox = new QComboBox;
	for (int i = 0; !Plot::AXIS[i].isEmpty(); i++) {
		axisComboBox->addItem(Plot::AXIS[i]);
	}

	QHBoxLayout *axisLayout = new QHBoxLayout;
	axisLayout->addWidget(axisComboBox);
	axisLayout->addStretch();

	axisGroupBox = new QGroupBox(tr("A&xes"));
	axisGroupBox->setCheckable(true);
	axisGroupBox->setLayout(axisLayout);
	connect(axisGroupBox, SIGNAL(toggled(bool)),
			axisComboBox, SLOT(setEnabled(bool)));

	QVBoxLayout *mainLayout = new QVBoxLayout;
	mainLayout->addWidget(axisGroupBox);
	mainLayout->addStretch();

	setLayout(mainLayout);
}

void PlotOthersWidget::setPlotAxis(int axis)
{
	bool hasAxis = (axis >= 0);
	axisGroupBox->setChecked(hasAxis);
	axisComboBox->setEnabled(hasAxis);
	if (hasAxis) {
		axisComboBox->setCurrentIndex(axis);
	}
}

int PlotOthersWidget::plotAxis() const
{
	int axis;
	if (!axisGroupBox->isChecked()) {
		axis = -1;
	} else {
		axis = axisComboBox->currentIndex();
	}
	return axis;
}
