/*
 * Cueplot: a GUI front end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef PLOT_STYLE_WIDGET_INCLUDED
#define PLOT_STYLE_WIDGET_INCLUDED

class PlotStyle;

#include <QWidget>
class QCheckBox;
class QComboBox;
class QDoubleSpinBox;
class QSpinBox;

class PlotStyleWidget : public QWidget
{
	Q_OBJECT

	public:
		PlotStyleWidget(QWidget *parent = 0);

		void setPlotStyle(const PlotStyle &plotStyle);
		PlotStyle plotStyle() const;

	private slots:
		void setWidget(bool isEnabled);

	private:
		// don't implement these
		PlotStyleWidget(const PlotStyleWidget &);
		PlotStyleWidget &operator=(const PlotStyleWidget &);

		QCheckBox *styleCheckBox;
		QComboBox *styleComboBox;
		QCheckBox *lineTypeCheckBox;
		QSpinBox *lineTypeSpinBox;
		QCheckBox *lineWidthCheckBox;
		QDoubleSpinBox *lineWidthDoubleSpinBox;
		QCheckBox *pointTypeCheckBox;
		QSpinBox *pointTypeSpinBox;
		QCheckBox *pointSizeCheckBox;
		QDoubleSpinBox *pointSizeDoubleSpinBox;
};
#endif // PLOT_STYLE_WIDGET_INCLUDED
