/*
 * Cueplot: a GUI front end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef BOX_WIDTH_INCLUDED
#define BOX_WIDTH_INCLUDED

#include "Option.h"

class QString;

class BoxWidth : public Option
{
	public:
		BoxWidth();

		void setAuto(bool flag);
		bool isAuto() const;

		void setWidth(double width); 
		double width() const;

		void setAbsolute(bool absolute);
		bool isAbsolute() const;

		QString command() const;

	private:
		static const double DEFAULT_WIDTH;
		double width_;
		bool isAbsolute_;
};
#endif // BOX_WIDTH_INCLUDED
