/*
 * Cueplot: a GUI front end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "Label.h"

#include <QStringList>

const double Label::DEFAULT_FONT_SIZE = 0;

Label::Label()
{
	for (int i = 0; i < AXIS_NUM; i++) {
		labelArray[i] = "";
		xOffsetArray[i] = 0.000000;
		yOffsetArray[i] = 0.000000;
		fontNameArray[i] = "";
		fontSizeArray[i] = DEFAULT_FONT_SIZE;
		lineTypeArray[i] = DEFAULT_LINE_TYPE;
	}
}

void Label::setLabel(int axis, const QString &label)
{
	labelArray[axis] = label;
}

const QString &Label::label(int axis) const
{
	return labelArray[axis];
}

void Label::setXOffset(int axis, double xoff)
{
	xOffsetArray[axis] = xoff;
}

double Label::xOffset(int axis) const
{
	return xOffsetArray[axis];
}

void Label::setYOffset(int axis, double yoff)
{
	yOffsetArray[axis] = yoff;
}

double Label::yOffset(int axis) const
{
	return yOffsetArray[axis];
}

void Label::setFontName(int axis, const QString &name)
{
	fontNameArray[axis] = name;
}

const QString &Label::fontName(int axis) const
{
	return fontNameArray[axis];
}

void Label::setFontSize(int axis, double size)
{
	fontSizeArray[axis] = size;
}

double Label::fontSize(int axis) const
{
	return fontSizeArray[axis];
}

void Label::setLineType(int axis, int lt)
{
	lineTypeArray[axis] = lt;
}

int Label::lineType(int axis) const
{
	return lineTypeArray[axis];
}

QString Label::command() const
{
	QStringList commandList;
	static const QString AXIS[AXIS_NUM - 1] =
	{ "x", "y", "z", "x2", "y2", "cb" };
	for (int i = 0; i < AXIS_NUM; i++) {
		QString str = "set ";
		str += i ? AXIS[i - 1] + "label" : "title";
		str += " \"" + labelArray[i] 
			+ "\" " + QString::number(xOffsetArray[i]) + "," 
			+ QString::number(yOffsetArray[i]) + " font \"" 
			+ fontNameArray[i];
		if (fontSizeArray[i] != DEFAULT_FONT_SIZE) {
			str += "," + QString::number(fontSizeArray[i]);
		}
		str += "\"";
		if (lineTypeArray[i] != DEFAULT_LINE_TYPE) {
			str += " textcolor lt " 
				+ QString::number(lineTypeArray[i]);
		}
		commandList << str;
	}
	return commandList.join("\n");
}
