/*
 * Cueplot: a GUI front end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "LatexEmtex.h"

LatexEmtex::LatexEmtex() : isLatex_(true), fontName_(0),
	fontSize_(DEFAULT_FONT_SIZE)
{
	terminalType_ = "latex";
}

void LatexEmtex::setLatex(bool latex)
{
	isLatex_ = latex;
	terminalType_ = isLatex_ ? "latex" : "emtex";
}

bool LatexEmtex::isLatex() const
{
	return isLatex_;
}

void LatexEmtex::setFontName(int name)
{
	fontName_ = name;
}

int LatexEmtex::fontName() const
{
	return fontName_;
}

void LatexEmtex::setFontSize(int size)
{
	fontSize_ = size;
}

int LatexEmtex::fontSize() const
{
	return fontSize_;
}

QString LatexEmtex::terminalOption() const
{
	if (fontName_) {
		const QString NAME[] = { "courier", "roman" };
		return NAME[fontName_] + " " 
			+ QString::number(fontSize_);
	}
	return "";
}
