/*
 * Cueplot: a GUI front end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef LOG_SCALE_INCLUDED
#define LOG_SCALE_INCLUDED

#include "Option.h"

#include <QString>

class LogScale : public Option
{
	public:
		LogScale();

		void setLogScale(int axis, bool flag);
		bool isLogScale(int axis) const;

		void setBase(int axis, const QString &base);
		const QString &base(int axis) const;

		QString command() const;
	private:
		static const double DEFAULT_BASE;
		static const int AXIS_NUM = 6;
		bool flagArray[AXIS_NUM];
		QString baseArray[AXIS_NUM];
};
#endif // LOG_SCALE_INCLUDED
