/*
 * Cueplot: a GUI front end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "PostScript.h"

PostScript::PostScript() : mode_(0), enhances_(false), 
	isColor_(false), isBlackText_(true), isSolid_(false),
	dashLength_(1.0), lineWidth_(1.0), duplexing_(0), rounds_(false),
	samples_(2000), maxDeviation_(0.003), fontName_("Helvetica"),
	fontSize_(14)
{
	terminalType_ = "postscript";
}

void PostScript::setMode(int mode)
{
	mode_ = mode;
}

int PostScript::mode() const
{
	return mode_;
}

void PostScript::setEnhanced(bool enhanced)
{
	enhances_ = enhanced;
}

bool PostScript::enhances() const
{
	return enhances_;
}

void PostScript::setColor(bool color)
{
	isColor_ = color;
}

bool PostScript::isColor() const
{
	return isColor_;
}

void PostScript::setBlackText(bool black)
{
	isBlackText_ = black;
}

bool PostScript::isBlackText() const
{
	return isBlackText_;
}

void PostScript::setSolid(bool solid)
{
	isSolid_ = solid;
}

bool PostScript::isSolid() const
{
	return isSolid_;
}

void PostScript::setDashLength(double dl)
{
	dashLength_ = dl;
}

double PostScript::dashLength() const
{
	return dashLength_;
}

void PostScript::setLineWidth(double lw)
{
	lineWidth_ = lw;
}

double PostScript::lineWidth() const
{
	return lineWidth_;
}

void PostScript::setDuplexing(int duplex)
{
	duplexing_ = duplex;
}

int PostScript::duplexing() const
{
	return duplexing_;
}

void PostScript::setRounded(bool round)
{
	rounds_ = round;
}

bool PostScript::rounds() const
{
	return rounds_;
}

void PostScript::setFontFile(const QString &fileName, bool add)
{
	if (add) {
		if (fontFileList.contains(fileName)) {
			fontFileList << fileName;
		}
	} else {
		fontFileList.removeAll(fileName);
	}
}

const QStringList &PostScript::fontFile() const
{
	return fontFileList;
}

void PostScript::setPalFuncParam(int samples, double maxdeviation)
{
	samples_ = samples;
	maxDeviation_ = maxdeviation;
}

int PostScript::samples() const
{
	return samples_;
}

double PostScript::maxDeviation() const
{
	return maxDeviation_;
}

void PostScript::setFontName(const QString &name)
{
	fontName_ = name;
}

const QString &PostScript::fontName() const
{
	return fontName_;
}

void PostScript::setFontSize(int size)
{
	fontSize_ = size;
}

int PostScript::fontSize() const
{
	return fontSize_;
}

QString PostScript::terminalOption() const
{
	const QString MODE[] = { "landscape", "portrait", "eps" };
	const QString DUPLEXING[] 
		= { "defaultplex", "simplex", "duplex" };
	QString str = MODE[mode_] + " ";
	str += enhances_ ? "" : "no";
	str += "enhanced ";
	str += isColor_ ? "color" : "monochrome";
	str += " ";
	str += isBlackText_ ? "blacktext" : "colortext";
	str += " ";
	str += isSolid_ ? "solid" : "dashed";
	str += " dashlength " + 
		QString::number(dashLength_)
		+ " linewidth " + QString::number(lineWidth_)
		+ " " + DUPLEXING[duplexing_] + " palfuncparam "
		+ QString::number(samples_) + "," 
		+ QString::number(maxDeviation_) + " ";
	str += rounds_ ? "rounded" : "butt";
	str += " \"" + fontName_ + "\" " 
		+ QString::number(fontSize_);
	return str;
}
