/*
 * Cueplot: a GUI front end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "Range.h"

#include <QStringList>

Range::Range()
{
	for (int i = 0; i < AXIS_NUM; i++) {
		minArray[i] = "*";
		maxArray[i] = "*";
		reverseArray[i] = false;
		writeBackArray[i] = false;
		restoreArray[i] = false;
	}
}

void Range::setMinimum(int axis, const QString &min)
{
	minArray[axis] = min;
}

const QString &Range::minimum(int axis) const
{
	return minArray[axis];
}

void Range::setMaximum(int axis, const QString &max)
{
	maxArray[axis] = max;
}

const QString &Range::maximum(int axis) const
{
	return maxArray[axis];
}

void Range::setReverse(int axis, bool reverse)
{
	reverseArray[axis] = reverse;
}

bool Range::isReverse(int axis) const
{
	return reverseArray[axis];
}

void Range::setWrittenBack(int axis, bool writeBack)
{
	writeBackArray[axis] = writeBack;
}

bool Range::writeBacks(int axis) const
{
	return writeBackArray[axis];
}

void Range::setRestored(int axis, bool restore)
{
	restoreArray[axis] = restore;
}

bool Range::restores(int axis) const
{
	return restoreArray[axis];
}

QString Range::command() const
{
	QStringList commandList;
	const QString AXIS[] = { "x", "y", "z" };
	for (int i = 0; i < AXIS_NUM; i++) {
		QString str = "set " + AXIS[i] + "range ";
		if (restoreArray[i]) {
			str += "restore";
			commandList << str;
		} else {
			str += "[ " + minArray[i] + " : " + 
				maxArray[i] + " ] ";
			str += reverseArray[i] ? "" : "no";
			str += "reverse ";
			str += writeBackArray[i] ? "" : "no";
			str += "writeback";
			commandList << str;
		}
	}
	return commandList.join("\n");
}
