/*
 * Cueplot: a GUI front end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef RANGE_INCLUDED
#define RANGE_INCLUDED

#include "Option.h"

#include <QString>

class Range : public Option
{
	public:
		Range();

		void setMinimum(int axis, const QString &min);
		const QString &minimum(int axis) const;

		void setMaximum(int axis, const QString &max);
		const QString &maximum(int axis) const;

		void setReverse(int axis, bool reverse);
		bool isReverse(int axis) const;

		void setWrittenBack(int axis, bool writeBack);
		bool writeBacks(int axis) const;

		void setRestored(int axis, bool restore);
		bool restores(int axis) const;

		QString command() const;

	private:
		static const int AXIS_NUM = 3;
		QString minArray[AXIS_NUM];
		QString maxArray[AXIS_NUM];
		bool reverseArray[AXIS_NUM];
		bool writeBackArray[AXIS_NUM];
		bool restoreArray[AXIS_NUM];
};
#endif // RANGE_INCLUDED
