/*
 * Cueplot: a GUI front end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef TICS_INCLUDED
#define TICS_INCLUDED

#include "Option.h"

#include <QString>
#include <QStringList>

class Tics : public Option
{
	public:
		Tics();

		void setFlag(int axis, bool flag);
		bool flag(int axis) const;

		void setMirror(int axis, bool mirror);
		bool mirrors(int axis) const;

		void setBorder(int axis, bool border);
		bool isBorder(int axis) const;

		void setRotate(int axis, bool rotate,
				const QString &ang = QString());
		bool rotates(int axis) const;

		void setAutofreq(int axis);
		bool isAutofreq(int axis) const;

		void setIncrement(int axis, const QString &incr, 
				const QString &start = QString(), 
				const QString &end = QString());
		bool isIncrement(int axis) const;
		const QString &start(int axis) const;
		const QString &increment(int axis) const;
		const QString &end(int axis) const;

		void setPosition(int axis, const QStringList &pos);
		bool isPosition(int axis) const;
		const QStringList &position(int axis) const;

		QString command() const;

		static const QString AXIS[];
	private:
		static const int AXIS_NUM = 5;
		bool flagArray[AXIS_NUM];
		bool borderArray[AXIS_NUM];
		bool mirrorArray[AXIS_NUM];
		bool rotateArray[AXIS_NUM];
		QString angArray[AXIS_NUM];

		int modeArray[AXIS_NUM];
		static const int AUTOFREQ = 0;
		static const int INCR = 1;
		static const int POS = 2;

		QString incrArray[3][AXIS_NUM];

		QStringList posList[AXIS_NUM];
};
#endif // TICS_INCLUDED
