/*
 * Cueplot: a GUI front end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "PlotModifier.h"

const QString PlotModifier::SMOOTH[] = { "unique", "frequency", "csplines",
	"acsplines", "bezier", "sbezier", ""
};

PlotModifier::PlotModifier() : m_(-1), n_(-1), p_(-1), smooth_(-1)
{
	for (int i = 0; i < EVERY_NUM; i++) {
		everyArray[i] = -1;
	}
}

void PlotModifier::setIndex(int m, int n, int p)
{
	m_ = m;
	n_ = n;
	p_ = p;
}

int PlotModifier::m() const
{
	return m_;
}

int PlotModifier::n() const
{
	return n_;
}

int PlotModifier::p() const
{
	return p_;
}

void PlotModifier::setEvery(int pointIncr, int blockIncr,
		int startPoint, int startBlock,
		int endPoint, int endBlock)
{
	everyArray[0] = pointIncr;
	everyArray[1] = blockIncr;
	everyArray[2] = startPoint;
	everyArray[3] = startBlock;
	everyArray[4] = endPoint;
	everyArray[5] = endBlock;
}

int PlotModifier::pointIncrement() const
{
	return everyArray[0];
}

int PlotModifier::blockIncrement() const
{
	return everyArray[1];
}

int PlotModifier::startPoint() const
{
	return everyArray[2];
}

int PlotModifier::startBlock() const
{
	return everyArray[3];
}

int PlotModifier::endPoint() const
{
	return everyArray[4];
}

int PlotModifier::endBlock() const
{
	return everyArray[5];
}

void PlotModifier::setUsing(const QStringList &entry, const QString &format)
{
	entry_ = entry;
	format_ = format;
}

const QStringList &PlotModifier::entry() const
{
	return entry_;
}

const QString &PlotModifier::format() const
{
	return format_;
}

void PlotModifier::setSmooth(int smooth)
{
	smooth_ = smooth;
}

int PlotModifier::smooth() const
{
	return smooth_;
}

QString PlotModifier::option() const
{
	QString str;
	// index
	if (m_ >= 0) {
		str += "index " + QString::number(m_);
		if (n_ >= 0) {
			str += ":" + QString::number(n_);
			if (p_ > 0) {
				str += ":" + QString::number(p_);
			}
		}
		str += " ";
	}
	// every
	QString everyStr;
	bool flag = false;
	for (int i = 0; i < EVERY_NUM; i++) {
		if (everyArray[i] >= 0) {
			everyStr += QString::number(everyArray[i]);
			flag = true;
		}
		everyStr += ":";
	}
	if (flag) {
		while (everyStr.endsWith(":")) {
			everyStr.chop(1);
		}
		str += "every " + everyStr + " ";
	}
	// using
	if (entry_.size() || !format_.isEmpty()) {
		str += "using ";
		if (entry_.size()) {
			str += entry_.join(":");
		}
		if (!format_.isEmpty()) {
			str += " '" + format_ + "' ";
		}
	}
	// smooth
	if (smooth_ >= 0) {
		str += "smooth " + SMOOTH[smooth_];
	}
	return str;
}
