/*
 * Cueplot: a GUI front end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef PLOT_RANGE_INCLUDED
#define PLOT_RANGE_INCLUDED

#include "CommandOption.h"

#include <QString>

class PlotRange : public CommandOption
{
	public:
		PlotRange();

		void setParametric(bool isParametric);
		bool isParametric() const;

		void setDummyVariable(int axis, const QString &var);
		const QString &dummyVariable(int axis) const;

		void setMinimum(int axis, const QString &min);
		const QString &minimum(int axis) const;

		void setMaximum(int axis, const QString &max);
		const QString &maximum(int axis) const;

		QString option() const;
	private:
		bool isParametric_;
		// 0 -> t, 1 -> x, 2 -> y
		static const int AXIS_NUM = 3;
		QString dummyVarArray[AXIS_NUM];
		QString minArray[AXIS_NUM];
		QString maxArray[AXIS_NUM];
};
#endif // PLOT_RANGE_INCLUDED
