/*
 * Cueplot: a GUI front end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef PLOT_STYLE_INCLUDED
#define PLOT_STYLE_INCLUDED

#include "CommandOption.h"

#include <QString>

class PlotStyle : public CommandOption
{
	public:
		PlotStyle();

		void setStyle(int style);
		int style() const;

		void setLineType(int lt);
		int lineType() const;

		void setLineWidth(double lw);
		double lineWidth() const;

		void setPointType(int pt);
		int pointType() const;

		void setPointSize(double ps);
		double pointSize() const;

		void setFill(const QString &fs);
		const QString &fill() const;

		void setPalette(bool palette);
		bool isPalette() const;

		QString option() const;

		static const QString STYLE[];
	private:
		int style_;
		int lineType_;
		double lineWidth_;
		int pointType_;
		double pointSize_;
		QString fill_;
		bool isPalette_;
};

#endif // PLOT_STYLE_INCLUDED
