/*
 * Cueplot: a GUI front end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef FIT_DIALOG_INCLUDED
#define FIT_DIALOG_INCLUDED

class FitBasicWidget;
class FitModifierWidget;
class FitOthersWidget;
class FitRangeWidget;

#include <QDialog>
class QListWidget;
class QListWidgetItem;
class QPushButton;
class QStackedWidget;

class FitDialog : public QDialog
{
	Q_OBJECT

	public:
		static FitDialog &instance(QWidget *parent = 0);
		static void destroyInstance();

	private slots:
		void fit();
		void setPushButton();
		void changePage(QListWidgetItem *current, QListWidgetItem *previous);

	signals:
		void executed(const QString &command);

	private:
		FitDialog(QWidget *parent = 0);
		// don't implement these
		FitDialog(const FitDialog &);
		FitDialog &operator=(const FitDialog &);

		void init();
		static FitDialog *instance_;

		QStackedWidget *pagesStackedWidget;
		QListWidget *contentsListWidget;
		FitBasicWidget *fitBasicWidget;
		FitModifierWidget *fitModifierWidget;
		FitOthersWidget *fitOthersWidget;
		FitRangeWidget *fitRangeWidget;
		QPushButton *fitPushButton;
};
#endif // FIT_DIALOG_INCLUDED
