/*
 * Cueplot: a GUI front end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef PROCESS_INCLUDED
#define PROCESS_INCLUDED

class ConsoleDialog;

#include <QObject>
class QProcess;
class QString;

class Process : public QObject
{
	Q_OBJECT

	public:
		Process(QObject *parent = 0);

		void closeDialog();
		void setDialogVisible(bool visible);
		bool isDialogVisible();

	public slots:
		void execute(const QString &command);

	private slots:
		void readStandardError();

	private:
		// don't implement these 
		Process(const Process &);
		Process &operator=(const Process &);

		bool startProcess();
		bool canStart(const QString &path);

		QProcess *process;
		ConsoleDialog *consoleDialog;
};

#endif // PROCESS_INCLUDED
