/*
 * Cueplot: a GUI front end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef KEY_OPTION_WIDGET_INCLUDED
#define KEY_OPTION_WIDGET_INCLUDED

#include "OptionWidget.h"

class Key;

#include <QList>
class QCheckBox;
class QComboBox;
class QDoubleSpinBox;
class QGroupBox;
class QLabel;
class QLineEdit;
class QRadioButton;
class QSpinBox;

class KeyOptionWidget : public OptionWidget
{
	Q_OBJECT

	public:
		KeyOptionWidget(QWidget *parent = 0);
		~KeyOptionWidget();

		void construct();

	private slots:
		void validatePosition();

	private:
		// don't implement these
		KeyOptionWidget(const KeyOptionWidget &);
		KeyOptionWidget &operator=(const KeyOptionWidget &);

		void init();
		void apply();
		void setWidget();
		Key *key;
		QCheckBox *keyCheckBox;
		QComboBox *positionComboBox;
		QList<QCheckBox *> positionCheckBoxList;
		QList<QDoubleSpinBox *> positionDoubleSpinBoxList;
		QGroupBox *boxGroupBox;
		QCheckBox *textJustifyCheckBox;
		QCheckBox *reverseCheckBox;
		QDoubleSpinBox *sampleLengthDoubleSpinBox;
		QDoubleSpinBox *spacingDoubleSpinBox;
		QDoubleSpinBox *widthIncrementDoubleSpinBox;
		QDoubleSpinBox *heightIncrementDoubleSpinBox;
		QCheckBox *autoTitlesCheckBox;
		QLineEdit *legendTitleLineEdit;
		QCheckBox *enhancedCheckBox;
		QSpinBox *lineTypeSpinBox;
		QLabel *lineTypeLabel;
		QDoubleSpinBox *lineWidthDoubleSpinBox;
		QLabel *lineWidthLabel;
};
#endif // KEY_OPTION_WIDGET_INCLUDED
