/*
 * Cueplot: a GUI front end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "TerminalLatexEmtexOptionWidget.h"
#include "TerminalLatexEmtex.h"

#include <QComboBox>
#include <QGridLayout>
#include <QLabel>
#include <QSpinBox>

TerminalLatexEmtexOptionWidget::TerminalLatexEmtexOptionWidget(QWidget *parent)
: OptionWidget(parent), terminalLatexEmtex(0)
{
}

TerminalLatexEmtexOptionWidget::~TerminalLatexEmtexOptionWidget()
{
	delete terminalLatexEmtex;
}

void TerminalLatexEmtexOptionWidget::construct()
{
	fontNameComboBox = new QComboBox;
	fontNameComboBox->addItem("default");
	fontNameComboBox->addItem("roman");
	fontNameComboBox->addItem("courier");
	connect(fontNameComboBox, SIGNAL(activated(int)),
			this, SIGNAL(modified()));

	QLabel *fontNameLabel = new QLabel;
	fontNameLabel->setText(tr("&Font:"));
	fontNameLabel->setBuddy(fontNameComboBox);

	fontSizeSpinBox = new QSpinBox;
	connect(fontSizeSpinBox, SIGNAL(valueChanged(int)),
			this, SIGNAL(modified()));

	QLabel *fontSizeLabel = new QLabel;
	fontSizeLabel->setText(tr("&Size:"));
	fontSizeLabel->setBuddy(fontSizeSpinBox);

	QGridLayout *mainLayout = new QGridLayout;
	mainLayout->addWidget(fontNameLabel, 0, 0);
	mainLayout->addWidget(fontNameComboBox, 0, 1);
	mainLayout->addItem(new QSpacerItem(40, 20, 
				QSizePolicy::Expanding, QSizePolicy::Minimum), 0, 2);
	mainLayout->addWidget(fontSizeLabel, 1, 0);
	mainLayout->addWidget(fontSizeSpinBox, 1, 1);
	mainLayout->addItem(new QSpacerItem(20, 40,
				QSizePolicy::Minimum, QSizePolicy::Expanding), 2, 0);

	setLayout(mainLayout);
}

void TerminalLatexEmtexOptionWidget::init()
{
	delete terminalLatexEmtex;
	terminalLatexEmtex = new TerminalLatexEmtex;
	setWidget();
}

void TerminalLatexEmtexOptionWidget::apply()
{
	terminalLatexEmtex->setFontName(fontNameComboBox->currentIndex());
	terminalLatexEmtex->setFontSize(fontSizeSpinBox->value());

	emit executed(terminalLatexEmtex->command());
}

void TerminalLatexEmtexOptionWidget::setWidget()
{
	fontNameComboBox->setCurrentIndex(terminalLatexEmtex->fontName());
	fontSizeSpinBox->setValue(terminalLatexEmtex->fontSize());
}
