/*
 * Cueplot: a GUI front end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef BAR_INCLUDED
#define BAR_INCLUDED

#include "Option.h"

class QString;

class Bar : public Option
{
	public:
		Bar();

		void setSmall(bool small);
		bool isSmall() const;

		void setBig(bool big);
		bool isBig() const;

		void setSize(double size);
		double size() const;

		QString command() const;

	private:
		static const double SMALL;
		static const double LARGE;
		double size_;
};
#endif // BAR_INCLUDED
