/*
 * Cueplot: a GUI front end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "Grid.h"

#include <QStringList>

const int Grid::LAYER_DEFAULT = 0;
const int Grid::FRONT = 1;
const int Grid::BACK = 2;

const QString Grid::AXIS[] = {
	"x", "mx", "y", "my", "z", "mz", "x2", "mx2", "y2", "my2", 
	"cb", "mcb", ""
};

Grid::Grid() : layer(LAYER_DEFAULT)
{
	for (int i = 0; !AXIS[i].isEmpty(); i++) {
		flagList.append(false);
	}
}

void Grid::setGrid(int axis, bool flag)
{
	flagList[axis] = flag;
}

bool Grid::isGrid(int axis) const
{
	return flagList.at(axis);
}

void Grid::setLayerDefault()
{
	layer = LAYER_DEFAULT;
}

bool Grid::isLayerDefault() const
{
	return layer == LAYER_DEFAULT;
}

void Grid::setFront()
{
	layer = FRONT;
}

bool Grid::isFront() const
{
	return layer == FRONT;
}

void Grid::setBack()
{
	layer = BACK;
}

bool Grid::isBack() const
{
	return layer == BACK;
}

QString Grid::command() const
{
	if (!flagList.contains(true)) {
		return "unset grid";
	}
	QStringList commandList;
	QString ticsStr = "set grid ";
	for (int i = 0; !AXIS[i].isEmpty(); i++) {
		if (!flagList.at(i)) {
			ticsStr += "no";
		}
		ticsStr += AXIS[i] + "tics ";
	}
	commandList << ticsStr;
	QString layerStr = "set grid ";
	switch (layer) {
	case LAYER_DEFAULT:
		layerStr += "layerdefault";
		break;
	case FRONT:
		layerStr += "front";
		break;
	case BACK:
		layerStr += "back";
		break;
	}
	commandList << layerStr;
	return commandList.join("\n");
}
