/*
 * Cueplot: a GUI front end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "LogScale.h"

#include <QStringList>

const double LogScale::DEFAULT_BASE = 10.0;

const QString LogScale::AXIS[] = {
	"x", "y", "z", "x2", "y2", "cb", ""
};

LogScale::LogScale()
{
	for (int i = 0; !AXIS[i].isEmpty(); i++) {
		flagList.append(false);
		baseList.append(QString::number(DEFAULT_BASE));
	}
}

void LogScale::setLogScale(int axis, bool flag)
{
	flagList[axis] = flag;
}

bool LogScale::isLogScale(int axis) const
{
	return flagList.at(axis);
}

void LogScale::setBase(int axis, const QString &base)
{
	baseList[axis] = base;
}

const QString &LogScale::base(int axis) const
{
	return baseList.at(axis);
}

QString LogScale::command() const
{
	QStringList commandList = QStringList() << "unset logscale";
	for (int i = 0; !AXIS[i].isEmpty(); i++) {
		QString str;
		if (flagList.at(i)) {
			str += "set logscale " + AXIS[i];
			if (baseList.at(i) != QString::number(DEFAULT_BASE)) {
				str += " " + baseList.at(i);
			}
			commandList << str;
		}
	}
	return commandList.join("\n");
}
