/*
 * Cueplot: a GUI front end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef SIZE_INCLUDED
#define SIZE_INCLUDED

#include "Option.h"

class QString;

class Size : public Option
{
	public:
		Size();

		void setSquare(bool square);
		bool isSquare() const;

		void setRatio(double r);
		double ratio() const;

		void setXScale(double x);
		double xScale() const;

		void setYScale(double y);
		double yScale() const;

		void setNoRatio(bool no);
		bool isNoRatio() const;

		QString command() const;

	private:
		double ratio_;
		double xScale_;
		double yScale_;
};
#endif // SIZE_INCLUDED
