/*
 * Cueplot: a GUI front end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "Terminal.h"

#include <cstdlib> // getenv()

Terminal::Terminal() : status(TERMINAL)
{
	char *gnuTerm = std::getenv("GNUTERM");
	if (gnuTerm) {
		terminalType_ = gnuTerm;
	} else {
#if defined(Q_OS_MACX)
		terminalType_ = "aqua";
#elif defined(Q_OS_UNIX)
		terminalType_ = "x11";
#elif defined(Q_OS_WIN32)
		terminalType_ = "windows";
#elif
		terminalType_ = "unknown";
#endif
	}
}

void Terminal::setTerminalType(const QString &type)
{
	terminalType_ = type;
	status = TERMINAL;
}

const QString &Terminal::terminalType() const
{
	return terminalType_;
}

void Terminal::setPush()
{
	status = PUSH;
}

void Terminal::setPop()
{
	status = POP;
}

QString Terminal::terminalOption() const
{
	return "";
}

QString Terminal::command() const
{
	QString str = "set terminal ";
	switch (status) {
	case TERMINAL:
		str += terminalType_ + " " + terminalOption();
		break;
	case PUSH:
		str += "push";
		break;
	case POP:
		str += "pop";
		break;
	}

	return str;
}
