/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef FIT_RANGE_INCLUDED
#define FIT_RANGE_INCLUDED

#include "CommandOption.h"
#include "PlotRange.h"

class QString;

//! fit コマンドのオプション
class FitRange : public CommandOption
{
	public:
		FitRange();

		void setDummyVariable(int axis, const QString &var);
		const QString &dummyVariable(int axis) const;

		void setMinimum(int axis, const QString &min);
		const QString &minimum(int axis) const;

		void setMaximum(int axis, const QString &max);
		const QString &maximum(int axis) const;

		QString option() const;
	private:
		PlotRange plotRange;
};
#endif // FIT_RANGE_INCLUDED
