/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef PROCESS_INCLUDED
#define PROCESS_INCLUDED

class ConsoleDialog;

#include <QtCore/QObject>
class QProcess;
class QString;

//! gnuplot のプロセスを扱うクラス
class Process : public QObject
{
	Q_OBJECT

	public:
		explicit Process(QObject *parent = 0);

		void closeDialog();
		void setDialogVisible(bool visible);
		bool isDialogVisible();

	public slots:
		//! コマンドを実行する
		/*!
		 * \param command 実行するコマンド
		 */
		void execute(const QString &command);

	private slots:
		void readStandardError();

	private:
		// don't implement these 
		Process(const Process &);
		Process &operator=(const Process &);

		//! gnuplot のプロセスを起動する
		/*!
		 * \return 起動に成功したら true
		 */
		bool startProcess();
		//! 起動できるか調べる
		/*!
		 * \param path gnuplot のパス
		 * \return 起動できたら true
		 */
		bool canStart(const QString &path);

		QProcess *process;
		ConsoleDialog *consoleDialog;
};

#endif // PROCESS_INCLUDED
