/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "OutputOptionWidget.h"
#include "Output.h"

#include <QtCore/QCoreApplication>
#include <QtGui/QCheckBox>
#include <QtGui/QLineEdit>
#include <QtGui/QFileDialog>
#include <QtGui/QHBoxLayout>
#include <QtGui/QPushButton>
#include <QtGui/QVBoxLayout>

OutputOptionWidget::OutputOptionWidget(QWidget *parent)
: OptionWidget(parent), output(0)
{
	setWindowTitle(tr("Output"));
	setWhatsThis("set output");
}

OutputOptionWidget::~OutputOptionWidget()
{
	delete output;
}

void OutputOptionWidget::construct()
{
	defaultCheckBox = new QCheckBox;
	defaultCheckBox->setText(tr("&Specify"));
	connect(defaultCheckBox, SIGNAL(toggled(bool)),
			this, SIGNAL(modified()));

	fileNameLineEdit = new QLineEdit;
	connect(defaultCheckBox, SIGNAL(toggled(bool)),
			fileNameLineEdit, SLOT(setEnabled(bool)));
	connect(fileNameLineEdit, SIGNAL(textChanged(const QString &)),
			this, SIGNAL(modified()));

	fileNamePushButton = new QPushButton;
	fileNamePushButton->setText(tr("&Open..."));
	connect(defaultCheckBox, SIGNAL(toggled(bool)),
			fileNamePushButton, SLOT(setEnabled(bool)));
	connect(fileNamePushButton, SIGNAL(clicked(bool)),
			this, SLOT(setOutput()));

	QHBoxLayout *outputLayout = new QHBoxLayout;
	outputLayout->addWidget(defaultCheckBox);
	outputLayout->addWidget(fileNameLineEdit);
	outputLayout->addWidget(fileNamePushButton);
	outputLayout->addStretch();

	QVBoxLayout *mainLayout = new QVBoxLayout;
	mainLayout->addLayout(outputLayout);
	mainLayout->addStretch();

	setLayout(mainLayout);
}

void OutputOptionWidget::init()
{
	delete output;
	output = new Output;
	setWidget();
}

void OutputOptionWidget::apply()
{
	if (defaultCheckBox->isChecked()) {
		output->setFileName(fileNameLineEdit->text());
	}
	emit executed(output->command());
}

void OutputOptionWidget::setWidget()
{
	QString fileName = output->fileName();
	bool isEmpty = fileName.isEmpty();
	defaultCheckBox->setChecked(!isEmpty);
	fileNameLineEdit->setText(fileName);
	fileNameLineEdit->setEnabled(!isEmpty);
	fileNamePushButton->setEnabled(!isEmpty);
}

void OutputOptionWidget::setOutput()
{
	QString file = QFileDialog::getSaveFileName(this, tr("Set output") + " - " 
			+ QCoreApplication::applicationName(), currentFile);
	if (!file.isEmpty()) {
		fileNameLineEdit->setText(file);
		currentFile = file;
	}
}
