/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "SizeOptionWidget.h"
#include "Size.h"

#include <QtGui/QCheckBox>
#include <QtGui/QDoubleSpinBox>
#include <QtGui/QLabel>
#include <QtGui/QGridLayout>

SizeOptionWidget::SizeOptionWidget(QWidget *parent)
: OptionWidget(parent), size(0)
{
	setWindowTitle(tr("Size"));
	setWhatsThis("set size");
}

SizeOptionWidget::~SizeOptionWidget()
{
	delete size;
}

void SizeOptionWidget::construct()
{
	ratioCheckBox = new QCheckBox;
	ratioCheckBox->setText(tr("&Specify Ratio"));
	connect(ratioCheckBox, SIGNAL(toggled(bool)),
			this, SIGNAL(modified()));

	ratioDoubleSpinBox = new QDoubleSpinBox;
	ratioDoubleSpinBox->setMinimum(-99);
	connect(ratioCheckBox, SIGNAL(toggled(bool)),
			ratioDoubleSpinBox, SLOT(setEnabled(bool)));
	connect(ratioDoubleSpinBox, SIGNAL(valueChanged(double)),
			this, SIGNAL(modified()));

	hSizeDoubleSpinBox = new QDoubleSpinBox;
	connect(hSizeDoubleSpinBox, SIGNAL(valueChanged(double)),
			this, SIGNAL(modified()));

	QLabel *hLabel = new QLabel;
	hLabel->setText(tr("&Horizontal Size:"));
	hLabel->setBuddy(hSizeDoubleSpinBox);

	vSizeDoubleSpinBox = new QDoubleSpinBox;
	connect(vSizeDoubleSpinBox, SIGNAL(valueChanged(double)),
			this, SIGNAL(modified()));

	QLabel *vLabel = new QLabel;
	vLabel->setText(tr("&Vertical Size:"));
	vLabel->setBuddy(vSizeDoubleSpinBox);

	QGridLayout *mainLayout = new QGridLayout;
	mainLayout->addWidget(ratioCheckBox, 0, 0);
	mainLayout->addWidget(ratioDoubleSpinBox, 0, 1);
	mainLayout->addItem(new QSpacerItem(40, 20, 
				QSizePolicy::Expanding, QSizePolicy::Minimum), 0, 2);
	mainLayout->addWidget(hLabel, 1, 0);
	mainLayout->addWidget(hSizeDoubleSpinBox, 1, 1);
	mainLayout->addWidget(vLabel, 2, 0);
	mainLayout->addWidget(vSizeDoubleSpinBox, 2, 1);
	mainLayout->addItem(new QSpacerItem(20, 40,
				QSizePolicy::Minimum, QSizePolicy::Expanding), 3, 0);

	setLayout(mainLayout);
}

void SizeOptionWidget::init()
{
	delete size;
	size = new Size;
	setWidget();
}

void SizeOptionWidget::apply()
{
	bool hasRatio = ratioCheckBox->isChecked();
	size->setNoRatio(hasRatio);
	if (hasRatio) {
		size->setRatio(ratioDoubleSpinBox->value());
	}
	size->setXScale(hSizeDoubleSpinBox->value());
	size->setYScale(vSizeDoubleSpinBox->value());

	emit executed(size->command());
}

void SizeOptionWidget::setWidget()
{
	bool flag = size->isNoRatio();
	ratioCheckBox->setChecked(!flag);
	ratioDoubleSpinBox->setEnabled(!flag);
	ratioDoubleSpinBox->setValue(size->ratio());
	hSizeDoubleSpinBox->setValue(size->xScale());
	vSizeDoubleSpinBox->setValue(size->yScale());
}
