# from a source file of LabLux at revision 160
FIND_PROGRAM(QT_LUPDATE_EXECUTABLE NAMES lupdate lupdate-qt4 PATHS
		"[HKEY_CURRENT_USER\\Software\\Trolltech\\Qt3Versions\\4.0.0;InstallDir]/bin"
		"[HKEY_CURRENT_USER\\Software\\Trolltech\\Versions\\4.0.0;InstallDir]/bin"
		$ENV{QTDIR}/bin)

FIND_PROGRAM(QT_LRELEASE_EXECUTABLE NAMES lrelease lrelease-qt4 PATHS
		"[HKEY_CURRENT_USER\\Software\\Trolltech\\Qt3Versions\\4.0.0;InstallDir]/bin"
		"[HKEY_CURRENT_USER\\Software\\Trolltech\\Versions\\4.0.0;InstallDir]/bin"
		$ENV{QTDIR}/bin)

FIND_PROGRAM(SED_EXECUTABLE NAMES sed PATHS /sw/bin /usr/bin /bin)
FIND_PROGRAM(MV_EXECUTABLE NAMES mv PATHS /sw/bin /usr/bin /bin)

# QT4_WRAP_TS(outfiles infiles ...)
# outfiles receives .qm generated files from
# .ts files in arguments
# a target lupdate is created for you
# update/generate your translations files
# example: QT4_WRAP_TS(foo_QM ${foo_TS})

MACRO (QT4_WRAP_TS outfiles)
	# a target to manually run lupdate
	ADD_CUSTOM_TARGET(lupdate
		COMMAND ${QT_LUPDATE_EXECUTABLE} ${CMAKE_CURRENT_SOURCE_DIR} -ts ${ARGN}
		WORKING_DIRECTORY ${CMAKE_CURRENT_SOURCE_DIR})

	FOREACH (it ${ARGN})
		# for Japanese ts files
		IF (APPLE)
			# sed "s/(&amp;[[:upper:]])//" $it > tmp
			# mv -f tmp $it
			EXECUTE_PROCESS(COMMAND ${SED_EXECUTABLE}
				"s/(&amp;[[:upper:]])//" ${it} 
				WORKING_DIRECTORY ${CMAKE_CURRENT_SOURCE_DIR}
				OUTPUT_FILE tmp)
			EXECUTE_PROCESS(COMMAND ${MV_EXECUTABLE} 
				-f tmp ${it}
				WORKING_DIRECTORY ${CMAKE_CURRENT_SOURCE_DIR})
		ENDIF (APPLE)
		GET_FILENAME_COMPONENT(outfile ${it} NAME_WE)
		SET(outfile ${CMAKE_CURRENT_BINARY_DIR}/${outfile}.qm)
		ADD_CUSTOM_COMMAND(OUTPUT ${outfile}
			COMMAND ${QT_LRELEASE_EXECUTABLE}
			ARGS ${CMAKE_CURRENT_SOURCE_DIR}/${it} -qm ${outfile}
			DEPENDS ${it})
		SET(${outfiles} ${${outfiles}} ${outfile})
	ENDFOREACH (it)
ENDMACRO (QT4_WRAP_TS)
