/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef CONFIG_DIALOG_INCLUDED
#define CONFIG_DIALOG_INCLUDED

class FileLineEdit;
class Process;

#include <QtGui/QDialog>
class QLineEdit;
class QRadioButton;

//! 設定ダイアログ
class ConfigDialog : public QDialog
{
	Q_OBJECT

	public:
		static ConfigDialog &instance(QWidget *parent = 0);
		static void destroyInstance();

		void setProcess(Process &process);

	private slots:
		//! 設定を適用してダイアログを閉じる
		void accept();
		//! 設定を適用する
		void apply();
		//! gnuplot を開く
		void openFile();

	private:
		ConfigDialog(QWidget *parent = 0);
		// don't implement these
		ConfigDialog(const ConfigDialog &);
		ConfigDialog &operator=(const ConfigDialog &);

		static ConfigDialog *instance_;

		Process *process_;
		QRadioButton *defaultRadioButton;
		QRadioButton *pathRadioButton;
		FileLineEdit *pathLineEdit;
		QPushButton *pathPushButton;
};
#endif // CONFIG_DIALOG_INCLUDED
