/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef FILE_LINE_EDIT_INCLUDED
#define FILE_LINE_EDIT_INCLUDED

#include <QtGui/QLineEdit>
class QDropEvent;

/*!
 * \brief ファイル名を表示するのに用いる Line Edit
 *
 * 表示されたファイル名は破棄されるときに保存される。
 */
class FileLineEdit : public QLineEdit
{
	Q_OBJECT

	public:
		explicit FileLineEdit(const QString &key = QString(),
				QWidget *parent = 0);
		~FileLineEdit();

		/*!
		 * \brief 表示するファイル名を設定する
		 * \param file 表示するファイル名
		 */
		void setFile(const QString &file);
		/*!
		 * \brief 表示するファイル名を返す
		 * \return 表示するファイル名
		 */
		const QString &file() const;

	private:
		// don't implement these
		FileLineEdit(const FileLineEdit &);
		FileLineEdit &operator=(const FileLineEdit &);

		void dragEnterEvent(QDragEnterEvent *event);
		void dropEvent(QDropEvent *event);

		const QString key_;
		QString file_;
};

#endif // FILE_LINE_EDIT_INCLUDED
