/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef PLOT_DATA_WIDGET_INCLUDED
#define PLOT_DATA_WIDGET_INCLUDED

class Plot;
class PlotListWidget;
class PlotOptionDialog;

#include <QtGui/QWidget>
class QListWidget;
class QListWidgetItem;
class QPushButton;
class QStringList;

//! プロットする項目を扱うウィジェット
class PlotDataWidget : public QWidget
{
	Q_OBJECT

	public:
		explicit PlotDataWidget(QWidget *parent = 0);
		~PlotDataWidget();

		/*!
		 * \brief リスト中に項目があるかどうかを返す
		 * \return 項目があれば true
		 */
		bool hasItem() const;
		/*!
		 * \brief プロットする項目に対応するコマンドを返す
		 * \return プロットする項目に対応するコマンド
		 */
		QStringList commandList() const;

		//! ダイアログをすべて閉じる
		void closeDialog();
		
	public slots:
		/*!
		 * \brief 項目を追加する
		 * \param plot 追加する項目
		 */
		void addData(Plot &plot);
		/*!
		 * \brief 項目が追加できるかどうかを設定する
		 * \param enable 追加できるようにするときは true
		 */
		void setAdditionEnabled(bool enable);

	private slots:
		//! 項目に対するオプションを設定するダイアログを表示する
		void setPlotOptions();
		//! 選択されている項目を上に移動させる
		void setDataUp();
		//! 選択されている項目を下に移動させる
		void setDataDown();
		//! 選択されている項目を削除する
		void deleteData();
		/*!
		 * \brief 項目の関数名またはファイル名を変更する
		 * \param item 変更対象の項目
		 */
		void changeItem(QListWidgetItem *item);
		//! リストの状態に応じてボタンの有効/無効を設定する
		void setPushButton();

	signals:
		/*!
		 * \brief このシグナルはプロット可能かどうかが変わったときに発信される
		 * \param enabled 可能になったときは true
		 */
		void setPlotEnabled(bool enabled);
		/*!
		 * \brief このシグナルはコマンドを実行するときに発信される
		 * \param command 実行するコマンド
		 */
		void executed(const QString &command);
		//! このシグナルは項目が追加されるときに発信される
		void dataAdded();

	private:
		// don't implement these
		PlotDataWidget(const PlotDataWidget &);
		PlotDataWidget &operator=(const PlotDataWidget &);

		//! リスト中の項目の状態に応じて、プロットできるかどうかを設定する
		void setAction();
		QList<Plot *> plotList;
		QList<PlotOptionDialog *> dialogList;
		QPushButton *addPushButton;
		QPushButton *optionPushButton;
		QPushButton *upPushButton;
		QPushButton *downPushButton;
		QPushButton *deletePushButton;
		PlotListWidget *plotListWidget;
};
#endif // PLOT_DATA_WIDGET_INCLUDED
