/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "PlotInputWidget.h"
#include "FileLineEdit.h"
#include "Plot.h"

#include <QtCore/QCoreApplication>
#include <QtGui/QLineEdit>
#include <QtGui/QFileDialog>
#include <QtGui/QPushButton>
#include <QtGui/QRadioButton>
#include <QtGui/QGridLayout>

PlotInputWidget::PlotInputWidget(QWidget *parent)
: QWidget(parent)
{
	functionRadioButton = new QRadioButton;
	functionRadioButton->setChecked(true);
	functionRadioButton->setText(tr("Function"));
	connect(functionRadioButton, SIGNAL(toggled(bool)),
			this, SLOT(changeInput()));

	functionLineEdit = new QLineEdit;
	connect(functionRadioButton, SIGNAL(toggled(bool)), 
			functionLineEdit, SLOT(setEnabled(bool)));
	connect(functionLineEdit, SIGNAL(returnPressed()),
			this, SLOT(addData()));
	connect(functionLineEdit, SIGNAL(textChanged(const QString &)),
			this, SLOT(changeInput()));

	filenameRadioButton = new QRadioButton;
	filenameRadioButton->setText(tr("File Name"));

	filenameLineEdit = new FileLineEdit("plot");
	filenameLineEdit->setEnabled(false);
	connect(filenameRadioButton, SIGNAL(toggled(bool)), 
			filenameLineEdit, SLOT(setEnabled(bool)));
	connect(filenameLineEdit, SIGNAL(returnPressed()),
			this, SLOT(addData()));
	connect(filenameLineEdit, SIGNAL(textChanged(const QString &)),
			this, SLOT(changeInput()));

	QPushButton *filenamePushButton = new QPushButton;
	filenamePushButton->setText(tr("&Open..."));
	filenamePushButton->setEnabled(false);
	connect(filenameRadioButton, SIGNAL(toggled(bool)), 
			filenamePushButton, SLOT(setEnabled(bool)));
	connect(filenamePushButton, SIGNAL(clicked()),
			this, SLOT(openDataFile()));

	// ----------- assemble layouts and widgets
	// ------------------------ create layouts

	QGridLayout *mainLayout = new QGridLayout;
	mainLayout->setMargin(0);
	mainLayout->addWidget(functionRadioButton, 0, 0);
	mainLayout->addWidget(functionLineEdit, 0, 1, 1, 2);
	mainLayout->addWidget(filenameRadioButton, 1, 0);
	mainLayout->addWidget(filenameLineEdit, 1, 1);
	mainLayout->addWidget(filenamePushButton, 1, 2);

	setLayout(mainLayout);
}

void PlotInputWidget::addData()
{
	bool isFunction = functionRadioButton->isChecked();
	QLineEdit *lineEdit = isFunction ? functionLineEdit : filenameLineEdit;
	QString data = lineEdit->text();
	if (data.isEmpty()) {
		return;
	}
	Plot *plot = new Plot;
	plot->setFunction(isFunction);
	isFunction ? plot->setFunction(data) : plot->setDataFile(data);
	emit dataAdded(*plot);
	lineEdit->clear();
}

void PlotInputWidget::openDataFile()
{
	QString file = QFileDialog::getOpenFileName(this,
			tr("Open a data file") + " - " 
			+ QCoreApplication::applicationName(),
			filenameLineEdit->file());
	if (!file.isNull()) {
		filenameLineEdit->setFile(file);
	}
}

void PlotInputWidget::changeInput()
{
	bool checked = functionRadioButton->isChecked();
	emit inputChanged(!(checked ? functionLineEdit : filenameLineEdit)->text()
			.isEmpty());
}
