/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "PlotListWidget.h"

#include <QtCore/QCoreApplication>
#include <QtGui/QAction>
#include <QtGui/QInputDialog>
#include <QtGui/QMenu>

PlotListWidget::PlotListWidget(QWidget *parent)
: QListWidget(parent)
{
	setContextMenuPolicy(Qt::CustomContextMenu);
	connect(this, SIGNAL(customContextMenuRequested(const QPoint &)),
			this, SLOT(showContextMenu(const QPoint &)));
}

void PlotListWidget::showContextMenu(const QPoint &/*pos*/)
{
	if (count() <= 0) {
		return;
	}
	QMenu *menu = new QMenu;
	QAction *editAct = new QAction(tr("&Edit..."), this);
	menu->addAction(editAct);
	QAction *action = menu->exec(QCursor::pos());


	if (action != editAct) {
		return;
	}
	bool ok;
	QString text 
		= QInputDialog::getText(this, tr("Edit") + " - " 
				+ QCoreApplication::applicationName(),
				tr("An Item Name:"), QLineEdit::Normal,
				currentItem()->text(), &ok);
	if (ok && !text.isEmpty()) {
		currentItem()->setText(text);
	}
}
