/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "AxisLabelOptionWidget.h"
#include "AxisLabel.h"

#include <QtGui/QComboBox>
#include <QtGui/QDoubleSpinBox>
#include <QtGui/QLabel>
#include <QtGui/QLineEdit>
#include <QtGui/QGridLayout>

AxisLabelOptionWidget::AxisLabelOptionWidget(QWidget *parent)
: AxisOptionWidget(parent), axisLabel(0)
{
	setWindowTitle(tr("Label"));
	setWhatsThis(tr("set <i>axis</i>label"));
}

AxisLabelOptionWidget::~AxisLabelOptionWidget()
{
	delete axisLabel;
}

void AxisLabelOptionWidget::construct()
{
	AxisOptionWidget::construct();
	for (int i = 0; !AxisLabel::AXIS[i].isEmpty(); i++) {
		axisComboBox->addItem(AxisLabel::AXIS[i]);
	}
}

void AxisLabelOptionWidget::init()
{
	delete axisLabel;
	axisLabel = new AxisLabel;
	setWidget();
}

void AxisLabelOptionWidget::apply()
{
	AxisOptionWidget::apply();
	emit executed(axisLabel->command());
}

void AxisLabelOptionWidget::constructWidget(QWidget *widget)
{
	labelLineEdit = new QLineEdit;
	connect(labelLineEdit, SIGNAL(textChanged(const QString &)),
			this, SIGNAL(modified()));

	QLabel *textLabel = new QLabel;
	textLabel->setText(tr("T&ext:"));
	textLabel->setBuddy(labelLineEdit);

	xOffsetDoubleSpinBox = new QDoubleSpinBox;
	xOffsetDoubleSpinBox->setMinimum(-99);
	connect(xOffsetDoubleSpinBox, SIGNAL(valueChanged(double)),
			this, SIGNAL(modified()));

	QLabel *xOffsetLabel = new QLabel;
	xOffsetLabel->setText(tr("X O&ffset:"));
	xOffsetLabel->setBuddy(xOffsetDoubleSpinBox);

	yOffsetDoubleSpinBox = new QDoubleSpinBox;
	yOffsetDoubleSpinBox->setMinimum(-99);
	connect(yOffsetDoubleSpinBox, SIGNAL(valueChanged(double)),
			this, SIGNAL(modified()));

	QLabel *yOffsetLabel = new QLabel;
	yOffsetLabel->setText(tr("&Y Offset:"));
	yOffsetLabel->setBuddy(yOffsetDoubleSpinBox);

	fontNameLineEdit = new QLineEdit;
	connect(fontNameLineEdit, SIGNAL(textChanged(const QString &)),
			this, SIGNAL(modified()));

	QLabel *fontNameLabel = new QLabel;
	fontNameLabel->setText(tr("Fo&nt Name:"));
	fontNameLabel->setBuddy(fontNameLineEdit);

	QGridLayout *mainLayout = new QGridLayout;
	mainLayout->addWidget(textLabel, 0, 0);
	mainLayout->addWidget(labelLineEdit, 0, 1, 1, 2);
	mainLayout->addWidget(xOffsetLabel, 1, 0);
	mainLayout->addWidget(xOffsetDoubleSpinBox, 1, 1);
	mainLayout->addItem(new QSpacerItem(40, 20,
				QSizePolicy::Expanding, QSizePolicy::Minimum), 1, 2);
	mainLayout->addWidget(yOffsetLabel, 2, 0);
	mainLayout->addWidget(yOffsetDoubleSpinBox, 2, 1);
	mainLayout->addWidget(fontNameLabel, 3, 0);
	mainLayout->addWidget(fontNameLineEdit, 3, 1, 1, 2);

	widget->setLayout(mainLayout);
}

void AxisLabelOptionWidget::setOption(int axis)
{
	axisLabel->setLabel(axis, labelLineEdit->text());
	axisLabel->setXOffset(axis, xOffsetDoubleSpinBox->value());
	axisLabel->setYOffset(axis, yOffsetDoubleSpinBox->value());
	axisLabel->setFontName(axis, fontNameLineEdit->text());
}

void AxisLabelOptionWidget::setAxisWidget(int axis)
{
	labelLineEdit->setText(axisLabel->label(axis));
	xOffsetDoubleSpinBox->setValue(axisLabel->xOffset(axis));
	yOffsetDoubleSpinBox->setValue(axisLabel->yOffset(axis));
	fontNameLineEdit->setText(axisLabel->fontName(axis));
}
